/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.recipe;

import com.petrolpark.compat.create.core.recipe.firsttimelucky.IFTLProcessingRecipe;
import com.petrolpark.core.recipe.IBiomeSpecificRecipe;
import com.petrolpark.core.recipe.book.IBookRequiredRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;

public class RecipeHelper {
    private static final Random r = new Random();

    public static List<ItemStack> rollResults(RandomSource random, ProcessingRecipe<?, ?> recipe, int multiplier) {
        return RecipeHelper.rollResults(random, recipe, null, multiplier);
    }

    public static List<ItemStack> rollResults(RandomSource random, ProcessingRecipe<?, ?> recipe, Player player, int multiplier) {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        if (recipe == null) {
            return results;
        }
        if (recipe instanceof IFTLProcessingRecipe) {
            IFTLProcessingRecipe luckyRecipe = (IFTLProcessingRecipe)recipe;
            if (player != null && multiplier > 0) {
                results.addAll(luckyRecipe.rollLuckyResults(player, random));
                --multiplier;
            }
        }
        if (multiplier <= 0) {
            return results;
        }
        for (ProcessingOutput output : recipe.getRollableResults()) {
            float expectedCount = (float)multiplier * output.getChance() * (float)output.getStack().getCount();
            int count = (int)expectedCount;
            if (r.nextFloat() < expectedCount - (float)count) {
                ++count;
            }
            int stackSize = output.getStack().getMaxStackSize();
            for (int i = 0; i < count / stackSize; ++i) {
                results.add(output.getStack().copyWithCount(stackSize));
            }
            results.add(output.getStack().copyWithCount(count % stackSize));
        }
        return results;
    }

    public static boolean isValidAt(RecipeHolder<?> recipeHolder, Level level, BlockPos pos) {
        IBookRequiredRecipe bookRequiredRecipe;
        IBiomeSpecificRecipe biomeSpecificRecipe;
        Recipe recipe = recipeHolder.value();
        if (recipe instanceof IBiomeSpecificRecipe && !(biomeSpecificRecipe = (IBiomeSpecificRecipe)recipe).isValidAt(level, pos)) {
            return false;
        }
        recipe = recipeHolder.value();
        return !(recipe instanceof IBookRequiredRecipe) || !(bookRequiredRecipe = (IBookRequiredRecipe)recipe).isBookRequired(level) || IBookRequiredRecipe.hasRequiredBook(level, pos, recipeHolder);
    }
}

