/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.recipe.book;

import com.petrolpark.core.recipe.book.IBookRequiredRecipe;
import com.petrolpark.util.LinkedHashSetQueue;
import com.petrolpark.util.Pair;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public interface IRecipeBookProviderBlock {
    public boolean providesRecipeBook(RecipeHolder<?> var1, Level var2, BlockPos var3, BlockState var4);

    public Stream<RecipeHolder<?>> streamProvidedRecipeBooks(Level var1, BlockPos var2, BlockState var3);

    default public boolean shouldHighlightConnectedRecipeBookAcceptors(Level level, BlockPos pos, BlockState state) {
        return true;
    }

    default public Set<Pair<BlockPos, ProvisionType>> getRecipeBookProvisions(Level level, BlockPos pos, BlockState state) {
        LinkedHashSetQueue acceptorPositions = new LinkedHashSetQueue();
        HashSet<BlockPos> checkedAcceptorPositions = new HashSet<BlockPos>();
        HashSet<Pair<BlockPos, ProvisionType>> provisions = new HashSet<Pair<BlockPos, ProvisionType>>();
        for (Direction face : Direction.values()) {
            acceptorPositions.add(pos.relative(face));
        }
        while (!acceptorPositions.isEmpty()) {
            BlockState acceptorState;
            BlockPos acceptorPos = (BlockPos)acceptorPositions.poll();
            if (!IBookRequiredRecipe.isRecipeBookAcceptor(level, acceptorPos, acceptorState = level.getBlockState(acceptorPos)) || !checkedAcceptorPositions.add(acceptorPos)) continue;
            provisions.add(Pair.of(acceptorPos, this.streamProvidedRecipeBooks(level, pos, state).anyMatch(rh -> IBookRequiredRecipe.acceptsRecipe(level, acceptorPos, acceptorState, rh)) ? ProvisionType.PROVIDES : ProvisionType.CAN_PROVIDE));
            IBookRequiredRecipe.addProxyRecipeBookAcceptorPositions(level, acceptorPos, acceptorState, acceptorPositions::add);
        }
        return provisions;
    }

    public static enum ProvisionType {
        CAN_PROVIDE,
        PROVIDES;

    }
}

