/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.recipe.compression;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.core.recipe.compression.ItemCompression;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public interface IItemCompression {
    public static final Codec<IItemCompression> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("count").forGetter(IItemCompression::count), (App)ItemStack.CODEC.fieldOf("result").forGetter(IItemCompression::result)).apply((Applicative)instance, IItemCompression::create));
    public static final StreamCodec<RegistryFriendlyByteBuf, IItemCompression> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, IItemCompression::count, (StreamCodec)ItemStack.STREAM_CODEC, IItemCompression::result, IItemCompression::create);
    public static final IItemCompression NONE = new IItemCompression(){

        @Override
        public int count() {
            return 0;
        }

        @Override
        public ItemStack result() {
            return ItemStack.EMPTY;
        }

        @Override
        public float ratio() {
            return 0.0f;
        }
    };

    public static IItemCompression create(int count, ItemStack result) {
        if (count == 0 || result.isEmpty()) {
            return NONE;
        }
        return new ItemCompression(count, result);
    }

    public int count();

    public ItemStack result();

    default public float ratio() {
        return (float)this.count() / (float)this.result().getCount();
    }
}

