/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.recipe.compression;

import com.petrolpark.Petrolpark;
import com.petrolpark.core.recipe.compression.FinishableMapItemCompressionSequence;
import com.petrolpark.core.recipe.compression.IItemCompression;
import com.petrolpark.core.recipe.compression.IItemCompressionSequence;
import com.petrolpark.core.recipe.compression.ItemCompression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RecipesUpdatedEvent;
import net.neoforged.neoforge.common.util.ItemStackMap;

@EventBusSubscriber
public class ItemCompressionManager {
    protected static final Map<ItemStack, IItemCompression> COMPRESSIONS = ItemStackMap.createTypeAndTagMap();
    protected static final Map<ItemStack, IItemCompressionSequence> COMPRESSION_SEQUENCES = ItemStackMap.createTypeAndTagMap();
    private static final List<Recipe<?>> singleInputRecipes = new ArrayList();

    public static Optional<IItemCompression> get(ItemStack stack) {
        return Optional.ofNullable(COMPRESSIONS.get(stack));
    }

    public static Optional<IItemCompressionSequence> getSequence(ItemStack stack) {
        return Optional.ofNullable(COMPRESSION_SEQUENCES.get(stack));
    }

    public static void reload(RecipeManager recipeManager) {
        COMPRESSIONS.clear();
        singleInputRecipes.clear();
        for (CompressionRecipe compression2 : recipeManager.getRecipes().stream().map(RecipeHolder::value).filter(CraftingRecipe.class::isInstance).map(r -> ItemCompressionManager.toCompressionRecipe(recipeManager.registries, r)).filter(Objects::nonNull).toList()) {
            Iterator<Recipe<?>> iterator = singleInputRecipes.iterator();
            while (iterator.hasNext()) {
                ItemStack decompressed;
                Recipe<?> recipe = iterator.next();
                if (!((Ingredient)recipe.getIngredients().get(0)).test(compression2.result()) || !compression2.isDecompressedStacks(decompressed = recipe.getResultItem(recipeManager.registries).copy())) continue;
                ItemStack decompressedSingle = decompressed.copyWithCount(1);
                if (COMPRESSIONS.putIfAbsent(decompressedSingle, compression2.compression()) != null) {
                    COMPRESSIONS.put(decompressedSingle, IItemCompression.NONE);
                }
                iterator.remove();
            }
        }
        COMPRESSIONS.replaceAll((stack, compression) -> compression == IItemCompression.NONE ? null : compression);
        ItemCompressionManager.rebuildCompressionSequences();
    }

    public static CompressionRecipe toCompressionRecipe(HolderLookup.Provider registries, Recipe<?> recipe) {
        int i;
        NonNullList ingredients = recipe.getIngredients();
        if (ingredients.size() == 0) {
            return null;
        }
        if (ingredients.size() == 1) {
            singleInputRecipes.add(recipe);
            return null;
        }
        Ingredient ingredient = (Ingredient)ingredients.get(0);
        for (i = 1; i < ingredients.size(); ++i) {
            if (ItemCompressionManager.areIngredientsEqual((Ingredient)ingredients.get(i), ingredient)) continue;
            return null;
        }
        return new CompressionRecipe(ingredient, i, recipe.getResultItem(registries).copy());
    }

    private static boolean areIngredientsEqual(Ingredient ingredient1, Ingredient ingredient2) {
        if (ingredient1 == ingredient2) {
            return true;
        }
        if (ingredient1.isCustom() != ingredient2.isCustom()) {
            return false;
        }
        if (ingredient1.isCustom()) {
            return Objects.equals(ingredient1.getCustomIngredient(), ingredient2.getCustomIngredient());
        }
        return Arrays.equals(ingredient1.getValues(), ingredient2.getValues());
    }

    public static final void rebuildCompressionSequences() {
        COMPRESSION_SEQUENCES.clear();
        COMPRESSIONS.forEach((stack, compression) -> {
            IItemCompressionSequence newSequence = ItemCompressionManager.putNewSequence(stack, () -> {
                FinishableMapItemCompressionSequence sequence = new FinishableMapItemCompressionSequence(stack.copy());
                IItemCompression nextCompression = compression;
                while (nextCompression != null) {
                    try {
                        if (!sequence.add(nextCompression)) {
                            return new EmptySharedItemCompressionSequence(sequence);
                        }
                    }
                    catch (ArithmeticException e) {
                        Petrolpark.LOGGER.warn("Item %s has too large of a compression factor to recognise compression sequence");
                        return new EmptySharedItemCompressionSequence(sequence);
                    }
                    nextCompression = COMPRESSIONS.get(nextCompression.result());
                }
                return sequence.finish();
            });
            if (newSequence != null) {
                newSequence.getAllItems().forEach(s -> COMPRESSION_SEQUENCES.merge((ItemStack)s, newSequence, (oldSequence, sequence) -> sequence.size() > oldSequence.size() ? sequence : oldSequence));
            }
        });
        COMPRESSION_SEQUENCES.replaceAll((stack, sequence) -> sequence.isEmpty() ? null : sequence);
    }

    private static IItemCompressionSequence putNewSequence(ItemStack stack, Supplier<IItemCompressionSequence> sequenceSupplier) {
        IItemCompressionSequence oldValue = COMPRESSION_SEQUENCES.get(stack);
        if (oldValue != null) {
            return oldValue;
        }
        IItemCompressionSequence sequence = sequenceSupplier.get();
        COMPRESSION_SEQUENCES.put(stack, sequence);
        return sequence;
    }

    @SubscribeEvent
    public static void onRecipeReload(RecipesUpdatedEvent event) {
        ItemCompressionManager.reload(event.getRecipeManager());
    }

    public record CompressionRecipe(Ingredient ingredient, ItemCompression compression) implements IItemCompression
    {
        public CompressionRecipe(Ingredient ingredient, int count, ItemStack result) {
            this(ingredient, new ItemCompression(count, result));
        }

        public boolean isDecompressedStacks(ItemStack decompressed) {
            return decompressed.getCount() * this.result().getCount() == this.count() && this.ingredient().test(decompressed);
        }

        @Override
        public int count() {
            return this.compression().count();
        }

        @Override
        public ItemStack result() {
            return this.compression().result();
        }
    }

    static class EmptySharedItemCompressionSequence
    extends IItemCompressionSequence.EmptyItemCompressionSequence {
        protected final List<ItemStack> items;

        public EmptySharedItemCompressionSequence(IItemCompressionSequence sequence) {
            this.items = sequence.getAllItems();
        }

        @Override
        public List<ItemStack> getAllItems() {
            return this.items;
        }
    }
}

