/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.recipe.compression;

import com.petrolpark.core.recipe.compression.IItemCompression;
import com.petrolpark.core.recipe.compression.IItemCompressionSequence;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.math.Fraction;

public class NoItemCompressionSequence
implements IItemCompressionSequence {
    protected final ItemStack stack;
    protected final Optional<IItemCompressionSequence.CompressedBlock> baseBlock;

    public NoItemCompressionSequence(ItemStack stack) {
        Optional<Object> optional;
        this.stack = stack.copyWithCount(1);
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            optional = Optional.of(new IItemCompressionSequence.CompressedBlock(blockItem.getBlock(), this.stack));
        } else {
            optional = Optional.empty();
        }
        this.baseBlock = optional;
    }

    @Override
    public ItemStack getBaseItem() {
        return this.stack.copy();
    }

    @Override
    public List<ItemStack> getAllItems() {
        return Collections.singletonList(this.stack.copy());
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public List<IItemCompression> getAllCompressions() {
        return Collections.emptyList();
    }

    @Override
    public Fraction getEquivalentBaseItems(ItemStack stack) {
        return ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)this.stack) ? Fraction.getFraction((int)stack.getCount(), (int)1) : null;
    }

    @Override
    public double getEquivalentBaseItems(ItemStack stack, double count) {
        return ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)this.stack) ? count : 0.0;
    }

    @Override
    public Optional<IItemCompressionSequence.CompressedBlock> getBaseBlock() {
        return this.baseBlock;
    }
}

