/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.recipe.crafting;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.petrolpark.util.CodecHelper;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public abstract class WrappedCraftingRecipe
implements CraftingRecipe {
    protected final CraftingRecipe wrappedRecipe;

    public CraftingRecipe getWrappedRecipe() {
        return this.wrappedRecipe;
    }

    public WrappedCraftingRecipe(CraftingRecipe wrappedRecipe) {
        this.wrappedRecipe = wrappedRecipe;
    }

    public boolean matches(@Nonnull CraftingInput input, @Nonnull Level level) {
        return this.wrappedRecipe.matches((RecipeInput)input, level);
    }

    public ItemStack assemble(@Nonnull CraftingInput input, @Nonnull HolderLookup.Provider registries) {
        return this.wrappedRecipe.assemble((RecipeInput)input, registries);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return this.wrappedRecipe.canCraftInDimensions(width, height);
    }

    public ItemStack getResultItem(@Nonnull HolderLookup.Provider registries) {
        return this.wrappedRecipe.getResultItem(registries);
    }

    public NonNullList<ItemStack> getRemainingItems(@Nonnull CraftingInput input) {
        return this.wrappedRecipe.getRemainingItems((RecipeInput)input);
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.wrappedRecipe.getIngredients();
    }

    public boolean isSpecial() {
        return this.wrappedRecipe.isSpecial();
    }

    public boolean showNotification() {
        return this.wrappedRecipe.showNotification();
    }

    public String getGroup() {
        return this.wrappedRecipe.getGroup();
    }

    public ItemStack getToastSymbol() {
        return this.wrappedRecipe.getToastSymbol();
    }

    public CraftingBookCategory category() {
        return this.wrappedRecipe.category();
    }

    public static final <RECIPE extends WrappedCraftingRecipe> NonNullSupplier<RecipeSerializer<RECIPE>> serializer(Function<CraftingRecipe, RECIPE> factory) {
        final MapCodec<WrappedCraftingRecipe> codec = CodecHelper.singleFieldMap(Recipe.CODEC.comapFlatMap(r -> {
            DataResult dataResult;
            if (r instanceof CraftingRecipe) {
                CraftingRecipe craftingRecipe = (CraftingRecipe)r;
                dataResult = DataResult.success((Object)craftingRecipe);
            } else {
                dataResult = DataResult.error(() -> String.format("{} is not a Crafting Recipe Type", r.getType()));
            }
            return dataResult;
        }, Function.identity()), "recipe", WrappedCraftingRecipe::getWrappedRecipe, factory);
        final StreamCodec streamCodec = StreamCodec.composite((StreamCodec)Recipe.STREAM_CODEC.map(recipe -> {
            if (recipe instanceof CraftingRecipe) {
                CraftingRecipe craftingRecipe = (CraftingRecipe)recipe;
                return craftingRecipe;
            }
            throw new IllegalStateException(String.format("{} is not a Crafting Recipe Type", recipe.getType()));
        }, Function.identity()), WrappedCraftingRecipe::getWrappedRecipe, factory);
        return () -> new RecipeSerializer<RECIPE>(){

            public MapCodec<RECIPE> codec() {
                return codec;
            }

            public StreamCodec<RegistryFriendlyByteBuf, RECIPE> streamCodec() {
                return streamCodec;
            }
        };
    }
}

