/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.recipe.ingredient.advanced;

import com.mojang.serialization.MapCodec;
import com.petrolpark.PetrolparkAdvancedIngredientTypes;
import com.petrolpark.core.recipe.ingredient.advanced.FluidAdvancedIngredient;
import com.petrolpark.core.recipe.ingredient.advanced.INamedAdvancedIngredientType;
import com.petrolpark.util.CodecHelper;
import com.petrolpark.util.Lang;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;

public record HolderSetFluidAdvancedIngredient(HolderSet<Fluid> set) implements FluidAdvancedIngredient
{
    public static final MapCodec<HolderSetFluidAdvancedIngredient> CODEC = CodecHelper.singleFieldMap(RegistryCodecs.homogeneousList((ResourceKey)Registries.FLUID), "set", HolderSetFluidAdvancedIngredient::set, HolderSetFluidAdvancedIngredient::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, HolderSetFluidAdvancedIngredient> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.holderSet((ResourceKey)Registries.FLUID), HolderSetFluidAdvancedIngredient::set, HolderSetFluidAdvancedIngredient::new);

    @Override
    public boolean test(FluidStack stack) {
        return this.set.contains(stack.getFluidHolder());
    }

    @Override
    public void addToDescription(Lang.IndentedTooltipBuilder description) {
        this.set.unwrap().map(tag -> description.add((Component)Component.translatable((String)"advanced_ingredient.petrolpark.tag", (Object[])new Object[]{tag})), items -> {
            description.add(this.translate("")).indent();
            items.stream().map(Holder::value).map(Fluid::getFluidType).map(FluidType::getDescription).forEach(description::add);
            return description.unindent();
        });
    }

    @Override
    public void addToCounterDescription(Lang.IndentedTooltipBuilder description) {
        this.set.unwrap().map(tag -> description.add((Component)Component.translatable((String)"advanced_ingredient.petrolpark.tag.inverse", (Object[])new Object[]{tag})), items -> {
            description.add(this.translateInverse(new Object[0])).indent();
            items.stream().map(Holder::value).map(Fluid::getFluidType).map(FluidType::getDescription).forEach(description::add);
            return description.unindent();
        });
    }

    @Override
    public INamedAdvancedIngredientType<FluidStack> getType() {
        return (INamedAdvancedIngredientType)PetrolparkAdvancedIngredientTypes.FLUID_HOLDER_SET.get();
    }
}

