/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.recipe.ingredient.advanced;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.petrolpark.PetrolparkAdvancedIngredientTypes;
import com.petrolpark.core.recipe.ingredient.advanced.GenericAdvancedIngredientType;
import com.petrolpark.core.recipe.ingredient.advanced.IAdvancedIngredient;
import com.petrolpark.core.recipe.ingredient.advanced.IForcingItemAdvancedIngredient;
import com.petrolpark.core.recipe.ingredient.advanced.ITypelessAdvancedIngredient;
import com.petrolpark.core.recipe.ingredient.advanced.TypeAttachedAdvancedIngredient;
import com.petrolpark.util.CodecHelper;
import com.petrolpark.util.Lang;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;

public record NotAdvancedIngredient<STACK>(IAdvancedIngredient<? super STACK> ingredient) implements ITypelessAdvancedIngredient<STACK>,
IForcingItemAdvancedIngredient
{
    public static final <STACK> MapCodec<NotAdvancedIngredient<STACK>> codec(Codec<IAdvancedIngredient<? super STACK>> typeCodec) {
        return CodecHelper.singleFieldMap(typeCodec, "ingredient", NotAdvancedIngredient::ingredient, NotAdvancedIngredient::new);
    }

    public static final <STACK> StreamCodec<? super RegistryFriendlyByteBuf, NotAdvancedIngredient<STACK>> streamCodec(StreamCodec<RegistryFriendlyByteBuf, IAdvancedIngredient<? super STACK>> typeStreamCodec) {
        return StreamCodec.composite(typeStreamCodec, NotAdvancedIngredient::ingredient, NotAdvancedIngredient::new);
    }

    public static final IAdvancedIngredient<ItemStack> of(IAdvancedIngredient<? super ItemStack> ingredient) {
        return ((GenericAdvancedIngredientType)PetrolparkAdvancedIngredientTypes.ITEM_NOT.get()).create(new NotAdvancedIngredient<ItemStack>(ingredient));
    }

    @Override
    public boolean test(STACK stack) {
        return !this.ingredient().test(stack);
    }

    @Override
    public Stream<STACK> streamExamples() {
        return this.ingredient().streamCounterExamples().map(this::checkedCast);
    }

    @Override
    public Stream<STACK> streamCounterExamples() {
        return this.ingredient().streamExamples().map(this::checkedCast);
    }

    @Override
    public Stream<STACK> modifyExamples(Stream<STACK> exampleStacks) {
        return this.ingredient().modifyCounterExamples(exampleStacks.map(this::checkedCast)).map(this::checkedCast);
    }

    @Override
    public Stream<STACK> modifyCounterExamples(Stream<STACK> counterExampleStacks) {
        return this.ingredient().modifyExamples(counterExampleStacks.map(this::checkedCast)).map(this::checkedCast);
    }

    @Override
    @Nonnull
    public Optional<ItemStack> forceLootItemFunction(LootItemFunction function, LootContext context, ItemStack stack) {
        IAdvancedIngredient<STACK> iAdvancedIngredient = this.ingredient();
        if (iAdvancedIngredient instanceof IForcingItemAdvancedIngredient) {
            IForcingItemAdvancedIngredient functionForcingIngredient = (IForcingItemAdvancedIngredient)((Object)iAdvancedIngredient);
            return functionForcingIngredient.forbidLootItemFunction(function, context, stack);
        }
        return Optional.empty();
    }

    @Override
    @Nonnull
    public Optional<ItemStack> forbidLootItemFunction(LootItemFunction function, LootContext context, ItemStack stack) {
        IAdvancedIngredient<STACK> iAdvancedIngredient = this.ingredient();
        if (iAdvancedIngredient instanceof IForcingItemAdvancedIngredient) {
            IForcingItemAdvancedIngredient functionForcingIngredient = (IForcingItemAdvancedIngredient)((Object)iAdvancedIngredient);
            return functionForcingIngredient.forceLootItemFunction(function, context, stack);
        }
        return Optional.empty();
    }

    @Override
    @Nullable
    public Optional<MerchantOffer> forceTradeListing(VillagerTrades.ItemListing tradeListing, Entity trader, RandomSource random) {
        IAdvancedIngredient<STACK> iAdvancedIngredient = this.ingredient();
        if (iAdvancedIngredient instanceof IForcingItemAdvancedIngredient) {
            IForcingItemAdvancedIngredient functionForcingIngredient = (IForcingItemAdvancedIngredient)((Object)iAdvancedIngredient);
            return functionForcingIngredient.forceTradeListing(tradeListing, trader, random);
        }
        return null;
    }

    @Override
    @Nullable
    public Optional<MerchantOffer> forbidTradeListing(VillagerTrades.ItemListing tradeListing, Entity trader, RandomSource random) {
        IAdvancedIngredient<STACK> iAdvancedIngredient = this.ingredient();
        if (iAdvancedIngredient instanceof IForcingItemAdvancedIngredient) {
            IForcingItemAdvancedIngredient functionForcingIngredient = (IForcingItemAdvancedIngredient)((Object)iAdvancedIngredient);
            return functionForcingIngredient.forbidTradeListing(tradeListing, trader, random);
        }
        return null;
    }

    @Override
    public void addToDescription(Lang.IndentedTooltipBuilder description) {
        this.ingredient().addToCounterDescription(description);
    }

    @Override
    public void addToCounterDescription(Lang.IndentedTooltipBuilder description) {
        this.ingredient().addToDescription(description);
    }

    @Override
    public ITypelessAdvancedIngredient<? super STACK> simplify() {
        TypeAttachedAdvancedIngredient ingredient;
        IAdvancedIngredient<Object> iAdvancedIngredient = this.ingredient();
        if (iAdvancedIngredient instanceof TypeAttachedAdvancedIngredient && (iAdvancedIngredient = (ingredient = (TypeAttachedAdvancedIngredient)iAdvancedIngredient).untypedIngredient()) instanceof NotAdvancedIngredient) {
            NotAdvancedIngredient notIngredient = (NotAdvancedIngredient)((Object)iAdvancedIngredient);
            return notIngredient.ingredient().simplify();
        }
        ITypelessAdvancedIngredient simplifiedIngredient = this.ingredient().simplify();
        if (simplifiedIngredient != this.ingredient()) {
            return new NotAdvancedIngredient<STACK>(simplifiedIngredient);
        }
        return this;
    }
}

