/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.recipe.recycling;

import com.petrolpark.core.contamination.Contaminant;
import com.petrolpark.core.contamination.ItemContamination;
import com.petrolpark.core.recipe.compression.ItemCompressionManager;
import com.petrolpark.core.recipe.recycling.RecyclingOutput;
import com.petrolpark.core.recipe.recycling.RecyclingOutputs;
import com.petrolpark.util.BigItemStack;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public interface RecyclingOutputsModifier {
    public static final RecyclingOutputsModifier DURABILITY = new RecyclingOutputsModifier(){

        @Override
        public void modify(Level level, ItemStack input, RecyclingOutputs outputs) {
            if (input.isDamaged()) {
                outputs.multiplyAll((float)input.getDamageValue() / (float)input.getMaxDamage());
            }
        }

        @Override
        public int getPriority() {
            return 0;
        }
    };
    public static final RecyclingOutputsModifier CONTAMINANTS = new RecyclingOutputsModifier(){

        @Override
        public void modify(Level level, ItemStack input, RecyclingOutputs outputs) {
            ItemContamination.get(input).streamAllContaminants().forEach(contaminant -> outputs.splitAll(((Contaminant)contaminant.value()).preservationProportion, output -> ItemContamination.get(output.item).contaminate((Holder<Contaminant>)contaminant)));
        }

        @Override
        public int getPriority() {
            return 1000;
        }
    };
    public static final RecyclingOutputsModifier DECOMPRESSION = new RecyclingOutputsModifier(){

        @Override
        public void modify(Level level, ItemStack input, RecyclingOutputs outputs) {
            outputs.forEach(output -> ItemCompressionManager.getSequence(output.item).ifPresent(sequence -> {
                double remainder = output.getExpectedRemainder();
                double baseItems = sequence.getEquivalentBaseItems(output.item, remainder);
                long wholeBaseItems = (long)baseItems;
                if (wholeBaseItems == 0L) {
                    return;
                }
                List<BigItemStack> compressedOutputs = sequence.getFewestStacks(wholeBaseItems);
                if (compressedOutputs.size() >= 2) {
                    output.expectedCount -= remainder;
                    outputs.addAll((Collection<? extends RecyclingOutput>)compressedOutputs.stream().map(RecyclingOutput::new).toList());
                    outputs.add(new RecyclingOutput(sequence.getBaseItem(), baseItems - (double)wholeBaseItems));
                }
            }));
        }

        @Override
        public int getPriority() {
            return 2000;
        }
    };

    public void modify(Level var1, ItemStack var2, RecyclingOutputs var3);

    public int getPriority();

    public static int compare(RecyclingOutputsModifier first, RecyclingOutputsModifier second) {
        return first.getPriority() - second.getPriority();
    }
}

