/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.scratch.argument;

import com.mojang.serialization.Codec;
import com.petrolpark.core.codec.ContextualCodec;
import com.petrolpark.core.codec.ContextualStreamCodec;
import com.petrolpark.core.scratch.argument.IScratchArgument;
import com.petrolpark.core.scratch.argument.IScratchParameter;
import com.petrolpark.core.scratch.environment.IScratchEnvironment;
import com.petrolpark.core.scratch.procedure.IScratchContextProvider;
import io.netty.buffer.ByteBuf;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;

public final class DropdownArgument<ENVIRONMENT extends IScratchEnvironment, TYPE>
extends Record
implements IScratchArgument<ENVIRONMENT, TYPE> {
    private final int index;
    private final DropdownParameter<ENVIRONMENT, TYPE> parameter;

    public DropdownArgument(int index, DropdownParameter<ENVIRONMENT, TYPE> parameter) {
        this.index = index;
        this.parameter = parameter;
    }

    @Override
    public TYPE get(ENVIRONMENT environment) {
        return ((DropdownParameter)this.parameter()).values.get(this.index).value();
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{DropdownArgument.class, "index;parameter", "index", "parameter"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DropdownArgument.class, "index;parameter", "index", "parameter"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DropdownArgument.class, "index;parameter", "index", "parameter"}, this, o);
    }

    public int index() {
        return this.index;
    }

    public DropdownParameter<ENVIRONMENT, TYPE> parameter() {
        return this.parameter;
    }

    public static class DropdownParameter<ENVIRONMENT extends IScratchEnvironment, TYPE>
    implements IScratchParameter<ENVIRONMENT, TYPE, DropdownArgument<ENVIRONMENT, TYPE>> {
        private final String key;
        private final List<Named<TYPE>> values;
        private final ContextualCodec<IScratchContextProvider<?>, DropdownArgument<ENVIRONMENT, TYPE>> codec;
        private final ContextualStreamCodec<ByteBuf, IScratchContextProvider<?>, DropdownArgument<ENVIRONMENT, TYPE>> streamCodec;

        public DropdownParameter(String key, List<Named<TYPE>> values) {
            this.key = key;
            this.values = values;
            this.codec = ContextualCodec.of(Codec.intRange((int)0, (int)(values.size() - 1))).xmap(i -> new DropdownArgument((int)i, this), DropdownArgument::index);
            this.streamCodec = ContextualStreamCodec.of(ByteBufCodecs.INT).map(i -> new DropdownArgument((int)i, this), DropdownArgument::index);
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public ContextualCodec<IScratchContextProvider<?>, DropdownArgument<ENVIRONMENT, TYPE>> argumentCodec() {
            return this.codec;
        }

        @Override
        public ContextualStreamCodec<? super RegistryFriendlyByteBuf, IScratchContextProvider<?>, DropdownArgument<ENVIRONMENT, TYPE>> argumentStreamCodec() {
            return this.streamCodec;
        }
    }

    public static interface Named<TYPE> {
        public TYPE value();

        public Component name();
    }
}

