/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.scratch.procedure;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.petrolpark.core.codec.ContextualCodec;
import com.petrolpark.core.codec.ContextualMapCodec;
import com.petrolpark.core.codec.ContextualStreamCodec;
import com.petrolpark.core.scratch.ScratchArguments;
import com.petrolpark.core.scratch.environment.IScratchEnvironment;
import com.petrolpark.core.scratch.procedure.IScratchContext;
import com.petrolpark.core.scratch.procedure.IScratchContextProvider;
import com.petrolpark.core.scratch.symbol.block.IInstantScratchBlock;
import com.petrolpark.core.scratch.symbol.block.IInstantiableScratchBlock;
import com.petrolpark.core.scratch.symbol.block.IScratchBlock;
import com.petrolpark.core.scratch.symbol.block.IScratchBlockInstance;
import io.netty.handler.codec.DecoderException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class ScratchProcedure<ENVIRONMENT extends IScratchEnvironment, CONTEXT extends IScratchContext<CONTEXT>>
implements IScratchContextProvider<CONTEXT> {
    protected final IScratchContextProvider<?> enclosingContextProvider;
    protected final List<Line<ENVIRONMENT, ?>> lines = new ArrayList();
    protected int currentLineNumber = 0;
    protected CurrentLine<ENVIRONMENT, ?, ?> currentLine = null;
    private final MapCodec<Line<ENVIRONMENT, ?>> lineMapCodec = new MapCodec<Line<ENVIRONMENT, ?>>(){
        private static final String BLOCK_KEY = "block";
        private static final String ARGUMENTS_KEY = "arguments";

        public <T> DataResult<Line<ENVIRONMENT, ?>> decode(DynamicOps<T> ops, MapLike<T> input) {
            return IScratchBlock.CODEC.parse(ops, input.get(BLOCK_KEY)).flatMap(block -> {
                try {
                    return DataResult.success((Object)block);
                }
                catch (ClassCastException e) {
                    return DataResult.error(() -> "pee");
                }
            }).flatMap(block -> this.decodeInternal(ops, input, (IScratchBlock)block));
        }

        public <T> RecordBuilder<T> encode(Line<ENVIRONMENT, ?> input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
            return this.encodeInternal(input, ops, prefix);
        }

        public <T> Stream<T> keys(DynamicOps<T> ops) {
            return Stream.of(BLOCK_KEY, ARGUMENTS_KEY).map(arg_0 -> ops.createString(arg_0));
        }

        private <T, ARGUMENTS extends ScratchArguments<? super ENVIRONMENT, ?>> DataResult<Line<ENVIRONMENT, ?>> decodeInternal(DynamicOps<T> ops, MapLike<T> input, IScratchBlock<? super ENVIRONMENT, ARGUMENTS, ?> block) {
            return block.getParameters().argumentsCodec().parse(ops, ScratchProcedure.this, input.get(ARGUMENTS_KEY)).map(arguments -> new Line(block, (ScratchArguments)arguments));
        }

        private <T, ARGUMENTS extends ScratchArguments<? super ENVIRONMENT, ?>> RecordBuilder<T> encodeInternal(Line<ENVIRONMENT, ARGUMENTS> line, DynamicOps<T> ops, RecordBuilder<T> builder) {
            builder.add(BLOCK_KEY, IScratchBlock.CODEC.encodeStart(ops, line.block()));
            builder.add(ARGUMENTS_KEY, line.block().getParameters().argumentsCodec().encodeStart(ops, ScratchProcedure.this, line.arguments()));
            return builder;
        }
    };
    private final Codec<List<Line<ENVIRONMENT, ?>>> linesCodec = this.lineMapCodec.codec().listOf();
    private final StreamCodec<RegistryFriendlyByteBuf, Line<ENVIRONMENT, ?>> lineStreamCodec = new StreamCodec<RegistryFriendlyByteBuf, Line<ENVIRONMENT, ?>>(){

        public Line<ENVIRONMENT, ?> decode(@Nonnull RegistryFriendlyByteBuf buffer) {
            IScratchBlock block = (IScratchBlock)IScratchBlock.STREAM_CODEC.decode((Object)buffer);
            try {
                return this.decodeInternal(buffer, block);
            }
            catch (ClassCastException e) {
                throw new DecoderException(String.format("Block {} has the wrong environment", block.getBlockType()));
            }
        }

        public void encode(@Nonnull RegistryFriendlyByteBuf buffer, @Nonnull Line<ENVIRONMENT, ?> value) {
            this.encodeInternal(buffer, value);
        }

        private <ARGUMENTS extends ScratchArguments<? super ENVIRONMENT, ?>> Line<ENVIRONMENT, ?> decodeInternal(RegistryFriendlyByteBuf buffer, IScratchBlock<? super ENVIRONMENT, ARGUMENTS, ?> block) {
            return new Line(block, (ScratchArguments)block.getParameters().argumentsStreamCodec().decode(buffer, ScratchProcedure.this));
        }

        private <ARGUMENTS extends ScratchArguments<? super ENVIRONMENT, ?>> void encodeInternal(RegistryFriendlyByteBuf buffer, Line<ENVIRONMENT, ARGUMENTS> value) {
            IScratchBlock.STREAM_CODEC.encode((Object)buffer, value.block());
            value.block().getParameters().argumentsStreamCodec().encode(buffer, ScratchProcedure.this, value.arguments());
        }
    };
    private final StreamCodec<RegistryFriendlyByteBuf, List<Line<ENVIRONMENT, ?>>> linesStreamCodec = this.lineStreamCodec.apply(ByteBufCodecs.list());

    public ScratchProcedure(IScratchContextProvider<?> enclosingContextProvider) {
        this.enclosingContextProvider = enclosingContextProvider;
    }

    public boolean run(ENVIRONMENT environment) {
        while (this.currentLine == null || this.currentLine.run(environment)) {
            this.currentLine = null;
            if (this.currentLineNumber < 0 || this.currentLineNumber >= this.lines.size()) {
                return true;
            }
            ++this.currentLineNumber;
            this.currentLine = this.lines.get(this.currentLineNumber).run(environment);
        }
        return false;
    }

    public void populateContext(CONTEXT context) {
        for (Line<ENVIRONMENT, ?> line : this.lines) {
            line.arguments().populateContext(this, context);
        }
    }

    public void exit() {
        this.currentLineNumber = this.lines.size();
        this.currentLine = null;
    }

    @Override
    public IScratchContextProvider<?> enclosingContextProvider() {
        return this.enclosingContextProvider;
    }

    public static <ENVIRONMENT extends IScratchEnvironment, CONTEXT extends IScratchContext<CONTEXT>> ContextualCodec<IScratchContextProvider<?>, ScratchProcedure<ENVIRONMENT, CONTEXT>> codec() {
        ContextualMapCodec mapCodec = new ContextualMapCodec<IScratchContextProvider<?>, ScratchProcedure<ENVIRONMENT, CONTEXT>>(){
            private static final String LINES_KEY = "lines";
            private static final String CURRENT_LINE_KEY = "current_line";
            private static final String CURRENT_INSTANCE_KEY = "current_instance";

            @Override
            public <T> DataResult<ScratchProcedure<ENVIRONMENT, CONTEXT>> decode(DynamicOps<T> ops, IScratchContextProvider<?> contextProvider, MapLike<T> input) {
                ScratchProcedure procedure = new ScratchProcedure(contextProvider);
                DataResult lines = procedure.linesCodec.parse(ops, input.get(LINES_KEY));
                if (lines.isError()) {
                    return lines.map(l -> procedure).setPartial(procedure);
                }
                procedure.lines.addAll((Collection)lines.getOrThrow());
                DataResult currentLine = Codec.intRange((int)0, (int)procedure.lines.size()).parse(ops, input.get(CURRENT_LINE_KEY));
                if (currentLine.isError()) {
                    return currentLine.map(c -> procedure).setPartial(procedure);
                }
                procedure.currentLineNumber = (Integer)currentLine.getOrThrow();
                return this.decodeCurrentInstance(ops, input, procedure, procedure.lines.get(procedure.currentLineNumber));
            }

            @Override
            public <T> RecordBuilder<T> encode(ScratchProcedure<ENVIRONMENT, CONTEXT> procedure, IScratchContextProvider<?> contextProvider, DynamicOps<T> ops, RecordBuilder<T> prefix) {
                prefix.add(LINES_KEY, procedure.linesCodec.encodeStart(ops, procedure.lines));
                prefix.add(CURRENT_LINE_KEY, Codec.INT.encodeStart(ops, (Object)procedure.currentLineNumber));
                if (procedure.currentLine != null) {
                    this.encodeCurrentInstance(ops, prefix, procedure.currentLine);
                }
                return prefix;
            }

            public <T> Stream<T> keys(DynamicOps<T> ops) {
                return Stream.of(LINES_KEY, CURRENT_LINE_KEY, CURRENT_INSTANCE_KEY).map(arg_0 -> ops.createString(arg_0));
            }

            private <T, ARGUMENTS extends ScratchArguments<? super ENVIRONMENT, ?>> DataResult<ScratchProcedure<ENVIRONMENT, CONTEXT>> decodeCurrentInstance(DynamicOps<T> ops, MapLike<T> input, ScratchProcedure<ENVIRONMENT, CONTEXT> procedure, Line<ENVIRONMENT, ARGUMENTS> line) {
                IScratchBlock iScratchBlock = line.block();
                if (iScratchBlock instanceof IInstantiableScratchBlock) {
                    IInstantiableScratchBlock instantiableScratchBlock = (IInstantiableScratchBlock)iScratchBlock;
                    return this.decodeCurrentInstanceInternal(ops, (T)input.get(CURRENT_INSTANCE_KEY), procedure, instantiableScratchBlock, line.arguments());
                }
                return DataResult.success(procedure);
            }

            private <T, ARGUMENTS extends ScratchArguments<? super ENVIRONMENT, ?>, INSTANCE extends IScratchBlockInstance<? super ENVIRONMENT>> DataResult<ScratchProcedure<ENVIRONMENT, CONTEXT>> decodeCurrentInstanceInternal(DynamicOps<T> ops, T value, ScratchProcedure<ENVIRONMENT, CONTEXT> procedure, IInstantiableScratchBlock<? super ENVIRONMENT, ARGUMENTS, INSTANCE, ?> block, ARGUMENTS arguments) {
                if (value == null) {
                    return DataResult.success(procedure);
                }
                return block.instanceCodec().parse(ops, arguments, value).map(instance -> {
                    procedure.currentLine = new CurrentLine(block, arguments, (IScratchBlockInstance)instance);
                    return procedure;
                });
            }

            private <T, ARGUMENTS extends ScratchArguments<? super ENVIRONMENT, ?>, INSTANCE extends IScratchBlockInstance<? super ENVIRONMENT>> void encodeCurrentInstance(DynamicOps<T> ops, RecordBuilder<T> builder, CurrentLine<ENVIRONMENT, ARGUMENTS, INSTANCE> currentLine) {
                builder.add(CURRENT_INSTANCE_KEY, currentLine.block().instanceCodec().encodeStart(ops, currentLine.arguments(), currentLine.instance()));
            }
        };
        return mapCodec.codec();
    }

    public static <ENVIRONMENT extends IScratchEnvironment, CONTEXT extends IScratchContext<CONTEXT>> ContextualStreamCodec<? super RegistryFriendlyByteBuf, IScratchContextProvider<?>, ScratchProcedure<ENVIRONMENT, CONTEXT>> streamCodec() {
        return new ContextualStreamCodec<RegistryFriendlyByteBuf, IScratchContextProvider<?>, ScratchProcedure<ENVIRONMENT, CONTEXT>>(){

            @Override
            public ScratchProcedure<ENVIRONMENT, CONTEXT> decode(RegistryFriendlyByteBuf buffer, IScratchContextProvider<?> contextProvider) {
                ScratchProcedure procedure = new ScratchProcedure(contextProvider);
                procedure.lines.addAll((Collection)procedure.linesStreamCodec.decode((Object)buffer));
                int currentLine = (Integer)ByteBufCodecs.INT.decode((Object)buffer);
                if (currentLine < 0 || currentLine >= procedure.lines.size()) {
                    throw new DecoderException("Current line out of range");
                }
                this.decodeCurrentInstance(buffer, procedure, procedure.lines.get(procedure.currentLineNumber));
                return procedure;
            }

            @Override
            public void encode(RegistryFriendlyByteBuf buffer, IScratchContextProvider<?> context, ScratchProcedure<ENVIRONMENT, CONTEXT> procedure) {
                procedure.linesStreamCodec.encode((Object)buffer, procedure.lines);
                ByteBufCodecs.INT.encode((Object)buffer, (Object)procedure.currentLineNumber);
                if (procedure.currentLine != null) {
                    this.encodeCurrentInstance(buffer, procedure.currentLine);
                }
            }

            private <ARGUMENTS extends ScratchArguments<? super ENVIRONMENT, ?>> void decodeCurrentInstance(RegistryFriendlyByteBuf buffer, ScratchProcedure<ENVIRONMENT, CONTEXT> procedure, Line<ENVIRONMENT, ARGUMENTS> line) {
                IScratchBlock iScratchBlock = line.block();
                if (iScratchBlock instanceof IInstantiableScratchBlock) {
                    IInstantiableScratchBlock instantiableScratchBlock = (IInstantiableScratchBlock)iScratchBlock;
                    this.decodeCurrentInstanceInternal(buffer, procedure, instantiableScratchBlock, line.arguments());
                }
            }

            private <ARGUMENTS extends ScratchArguments<? super ENVIRONMENT, ?>, INSTANCE extends IScratchBlockInstance<? super ENVIRONMENT>> void decodeCurrentInstanceInternal(RegistryFriendlyByteBuf buffer, ScratchProcedure<ENVIRONMENT, CONTEXT> procedure, IInstantiableScratchBlock<? super ENVIRONMENT, ARGUMENTS, INSTANCE, ?> block, ARGUMENTS arguments) {
                procedure.currentLine = new CurrentLine(block, arguments, (IScratchBlockInstance)block.instanceStreamCodec().decode(buffer, arguments));
            }

            private <ARGUMENTS extends ScratchArguments<? super ENVIRONMENT, ?>, INSTANCE extends IScratchBlockInstance<? super ENVIRONMENT>> void encodeCurrentInstance(RegistryFriendlyByteBuf buffer, CurrentLine<ENVIRONMENT, ARGUMENTS, INSTANCE> currentLine) {
                currentLine.block().instanceStreamCodec().encode(buffer, currentLine.arguments(), currentLine.instance());
            }
        };
    }

    public record CurrentLine<ENVIRONMENT extends IScratchEnvironment, ARGUMENTS extends ScratchArguments<? super ENVIRONMENT, ?>, INSTANCE extends IScratchBlockInstance<? super ENVIRONMENT>>(IInstantiableScratchBlock<? super ENVIRONMENT, ARGUMENTS, INSTANCE, ?> block, ARGUMENTS arguments, INSTANCE instance) {
        public CurrentLine(IInstantiableScratchBlock<? super ENVIRONMENT, ARGUMENTS, INSTANCE, ?> block, ARGUMENTS arguments, ENVIRONMENT environment) {
            this(block, arguments, block.run(environment, arguments));
        }

        public boolean run(ENVIRONMENT environment) {
            return this.instance().run(environment);
        }
    }

    public record Line<ENVIRONMENT extends IScratchEnvironment, ARGUMENTS extends ScratchArguments<? super ENVIRONMENT, ?>>(IScratchBlock<? super ENVIRONMENT, ARGUMENTS, ?> block, ARGUMENTS arguments) {
        @Nullable
        public CurrentLine<ENVIRONMENT, ARGUMENTS, ?> run(ENVIRONMENT environment) {
            IScratchBlock<ENVIRONMENT, ARGUMENTS, ?> iScratchBlock = this.block();
            if (iScratchBlock instanceof IInstantiableScratchBlock) {
                IInstantiableScratchBlock instantiableBlock = (IInstantiableScratchBlock)iScratchBlock;
                return new CurrentLine(instantiableBlock, this.arguments(), environment);
            }
            iScratchBlock = this.block();
            if (iScratchBlock instanceof IInstantScratchBlock) {
                IInstantScratchBlock instantBlock = (IInstantScratchBlock)iScratchBlock;
                instantBlock.run(environment, this.arguments());
            }
            return null;
        }
    }
}

