/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.shop.customer;

import com.petrolpark.PetrolparkLootContextParams;
import com.petrolpark.core.shop.customer.AbstractCustomer;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootParams;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.attachment.IAttachmentSerializer;
import org.jetbrains.annotations.Nullable;

public class EntityCustomer
extends AbstractCustomer {
    public final Entity entity;
    public static final IAttachmentSerializer<CompoundTag, EntityCustomer> ATTACHMENT_SERIALIZER = new IAttachmentSerializer<CompoundTag, EntityCustomer>(){

        public EntityCustomer read(@Nonnull IAttachmentHolder holder, @Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider provider) {
            EntityCustomer customer = EntityCustomer.create(holder);
            customer.deserializeNBT(provider, tag);
            return customer;
        }

        @Nullable
        public CompoundTag write(@Nonnull EntityCustomer attachment, @Nonnull HolderLookup.Provider provider) {
            return attachment.serializeNBT(provider);
        }
    };

    public static final EntityCustomer create(IAttachmentHolder attachmentHolder) {
        if (attachmentHolder instanceof Entity) {
            Entity entity = (Entity)attachmentHolder;
            return new EntityCustomer(entity);
        }
        throw new IllegalArgumentException(attachmentHolder.toString() + " is not an Entity");
    }

    public EntityCustomer(Entity entity) {
        this.entity = entity;
    }

    @Override
    public Component getName() {
        return this.entity.getDisplayName();
    }

    @Override
    public void supplyLootParams(LootParams.Builder builder) {
        builder.withParameter(PetrolparkLootContextParams.CUSTOMER_ENTITY, (Object)this.entity);
    }
}

