/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.simulation;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.yggdrasil.ServicesKeySet;
import com.petrolpark.core.simulation.AlwaysSprintingTickRateManager;
import com.petrolpark.core.simulation.SimulatedServerLevel;
import java.io.IOException;
import java.net.Proxy;
import javax.annotation.Nonnull;
import net.minecraft.CrashReport;
import net.minecraft.SystemReport;
import net.minecraft.Util;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerTickRateManager;
import net.minecraft.server.Services;
import net.minecraft.server.WorldStem;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.server.level.progress.LoggerChunkProgressListener;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.util.debugchart.LocalSampleLogger;
import net.minecraft.util.debugchart.SampleLogger;
import net.minecraft.util.profiling.EmptyProfileResults;
import net.minecraft.util.profiling.ProfileResults;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.LevelEvent;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class SimulatedServer
extends MinecraftServer {
    protected final boolean dedicated;
    protected final SampleLogger sampleLogger = new LocalSampleLogger(4);
    protected final AlwaysSprintingTickRateManager tickRateManager;

    public SimulatedServer(Thread serverThread, LevelStorageSource.LevelStorageAccess storageAccess, PackRepository packRepository, WorldStem worldStem, boolean dedicated) {
        super(serverThread, storageAccess, packRepository, worldStem, Proxy.NO_PROXY, DataFixers.getDataFixer(), new Services(null, ServicesKeySet.EMPTY, null, null), LoggerChunkProgressListener::createFromGameruleRadius);
        this.dedicated = dedicated;
        this.tickRateManager = new AlwaysSprintingTickRateManager(this);
    }

    protected boolean initServer() throws IOException {
        this.setPlayerList(new PlayerList(this, this, this.registries(), this.playerDataStorage, 0){});
        this.loadLevel();
        return true;
    }

    protected void createLevels(@Nonnull ChunkProgressListener listener) {
        SimulatedServerLevel overworld = new SimulatedServerLevel(this, Util.backgroundExecutor(), this.storageSource, this.worldData.overworldData(), (ResourceKey<Level>)Level.OVERWORLD, (LevelStem)this.registries().compositeAccess().registryOrThrow(Registries.LEVEL_STEM).get(LevelStem.OVERWORLD), listener, BiomeManager.obfuscateSeed((long)this.worldData.worldGenOptions().seed()));
        this.forgeGetWorldMap().put(Level.OVERWORLD, overworld);
        NeoForge.EVENT_BUS.post((Event)new LevelEvent.Load((LevelAccessor)overworld));
        this.worldData.overworldData().setInitialized(true);
        this.getPlayerList().addWorldborderListener((ServerLevel)overworld);
    }

    protected void runServer() {
    }

    public void onServerExit() {
        super.onServerExit();
    }

    public void onServerCrash(@Nonnull CrashReport report) {
        super.onServerCrash(report);
    }

    public ServerTickRateManager tickRateManager() {
        return this.tickRateManager;
    }

    public boolean isHardcore() {
        return false;
    }

    public int getOperatorUserPermissionLevel() {
        return 0;
    }

    public int getFunctionCompilationLevel() {
        return 4;
    }

    public boolean shouldRconBroadcast() {
        return false;
    }

    protected SampleLogger getTickTimeLogger() {
        return this.sampleLogger;
    }

    public boolean isTickTimeLoggingEnabled() {
        return false;
    }

    public boolean isTimeProfilerRunning() {
        return false;
    }

    public void startTimeProfiler() {
    }

    public ProfileResults stopTimeProfiler() {
        return EmptyProfileResults.EMPTY;
    }

    public SystemReport fillServerSystemReport(@Nonnull SystemReport report) {
        report.setDetail("Type", () -> String.format("Simulated {} server", this.isDedicatedServer() ? "dedicated" : "integrated"));
        return report;
    }

    public boolean isDedicatedServer() {
        return this.dedicated;
    }

    public int getRateLimitPacketsPerSecond() {
        return 0;
    }

    public boolean isEpollEnabled() {
        return false;
    }

    public boolean isCommandBlockEnabled() {
        return true;
    }

    public boolean isPublished() {
        return false;
    }

    public boolean shouldInformAdmins() {
        return false;
    }

    public boolean isSingleplayerOwner(@Nonnull GameProfile profile) {
        return false;
    }
}

