/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.team;

import com.mojang.serialization.DynamicOps;
import com.petrolpark.core.team.ITeam;
import javax.annotation.Nonnull;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.include.com.google.common.base.Objects;

public abstract class AbstractTeam
implements ITeam {
    protected final PatchedDataComponentMap components;

    protected AbstractTeam(DataComponentPatch components) {
        this.components = PatchedDataComponentMap.fromPatch((DataComponentMap)DataComponentMap.EMPTY, (DataComponentPatch)components);
    }

    protected AbstractTeam(PatchedDataComponentMap components) {
        this.components = components;
    }

    public DataComponentPatch getDataComponentPatch() {
        return this.components.asPatch();
    }

    @Nullable
    public Tag writeDataComponentsTag() {
        return (Tag)DataComponentPatch.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.getDataComponentPatch()).getOrThrow();
    }

    @Override
    public final boolean isNone() {
        return false;
    }

    public abstract void setChanged(DataComponentPatch var1);

    @Nullable
    public final <T> T set(@Nonnull DataComponentType<? super T> componentType, @Nonnull T value) {
        Object oldValue = this.components.set(componentType, value);
        if (!Objects.equal((Object)oldValue, value)) {
            this.setChanged(DataComponentPatch.builder().set(componentType, value).build());
        }
        return (T)oldValue;
    }

    @Nullable
    public final <T> T remove(@Nonnull DataComponentType<? extends T> componentType) {
        Object oldValue = this.components.remove(componentType);
        if (!Objects.equal((Object)oldValue, null)) {
            this.setChanged(DataComponentPatch.builder().remove(componentType).build());
        }
        return (T)oldValue;
    }

    public final void applyComponents(@Nonnull DataComponentPatch patch) {
        this.components.applyPatch(patch);
        this.setChanged(patch);
    }

    public final void applyComponents(@Nonnull DataComponentMap components) {
        this.components.setAll(components);
        DataComponentPatch.Builder builder = DataComponentPatch.builder();
        components.forEach(arg_0 -> ((DataComponentPatch.Builder)builder).set(arg_0));
        this.setChanged(builder.build());
    }

    public final DataComponentMap getComponents() {
        return this.components;
    }
}

