/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.team.packet;

import com.petrolpark.PetrolparkPackets;
import com.petrolpark.core.team.ITeam;
import com.petrolpark.core.team.ITeamBoundItem;
import com.petrolpark.core.team.packet.BindTeamPacket;
import net.createmod.catnip.net.base.BasePacketPayload;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class BindTeamItemPacket
extends BindTeamPacket {
    public static final StreamCodec<RegistryFriendlyByteBuf, BindTeamItemPacket> STREAM_CODEC = StreamCodec.composite(ITeam.Provider.STREAM_CODEC, BindTeamPacket::getTeamProvider, BindTeamItemPacket::new);

    public BindTeamItemPacket(ITeam.Provider teamProvider) {
        super(teamProvider);
    }

    @Override
    public void handle(ITeam.Provider teamProvider, ServerPlayer player) {
        ItemStack heldStack = player.getMainHandItem();
        Item item = heldStack.getItem();
        if (item instanceof ITeamBoundItem) {
            ITeamBoundItem bindableItem = (ITeamBoundItem)item;
            bindableItem.bind(teamProvider, heldStack, (Player)player);
        }
    }

    public BasePacketPayload.PacketTypeProvider getTypeProvider() {
        return PetrolparkPackets.BIND_TEAM_ITEM;
    }

    @Override
    public Component getDescription(ServerLevel level) {
        return this.translate(new Object[]{this.teamProvider.provideTeam((Level)level).getName()});
    }
}

