/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.team.scoreboard;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.petrolpark.Petrolpark;
import com.petrolpark.PetrolparkTeamProviderTypes;
import com.petrolpark.core.team.AbstractTeam;
import com.petrolpark.core.team.ITeam;
import com.petrolpark.core.team.NoTeam;
import com.petrolpark.util.CodecHelper;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.PlayerFaceRenderer;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.PlayerTeam;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ScoreboardTeam
extends AbstractTeam {
    public final Level level;
    public final PlayerTeam team;

    public static final ITeam.Provider provider(PlayerTeam team) {
        return new Provider(team.getName());
    }

    public ScoreboardTeam(Level level, PlayerTeam team) {
        this(level, team, DataComponentPatch.EMPTY);
    }

    protected ScoreboardTeam(Level level, PlayerTeam team, DataComponentPatch components) {
        super(components);
        this.level = level;
        this.team = team;
    }

    @Override
    public ITeam.Provider getProvider() {
        return ScoreboardTeam.provider(this.team);
    }

    @Override
    public boolean isMember(Player player) {
        return player.getTeam() == this.team;
    }

    @Override
    public int memberCount() {
        return this.team.getPlayers().size();
    }

    @Override
    public Stream<String> streamMemberUsernames() {
        return this.team.getPlayers().stream();
    }

    @Override
    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public Stream<Player> streamMembers() {
        MinecraftServer server = this.level.getServer();
        if (server != null) {
            return this.streamMemberUsernames().map(arg_0 -> ((PlayerList)server.getPlayerList()).getPlayerByName(arg_0));
        }
        return Stream.empty();
    }

    @Override
    public boolean isAdmin(Player player) {
        return player.hasPermissions(2);
    }

    @Override
    public Component getName() {
        return this.team.getDisplayName();
    }

    @Override
    public void setChanged(DataComponentPatch patch) {
        Petrolpark.SCOREBOARD_TEAMS.dataComponentChanged(this.level, this, patch);
    }

    @Override
    public void renderIcon(GuiGraphics graphics) {
        Integer color = this.team.getColor().getColor();
        RenderSystem.disableBlend();
        PoseStack ms = graphics.pose();
        graphics.fill(RenderType.guiOverlay(), 0, 0, 16, 16, color == null ? -1 : color | 0xFF000000);
        Minecraft mc = Minecraft.getInstance();
        ClientPacketListener connection = mc.getConnection();
        if (connection != null) {
            List<String> playerNames = this.streamMemberUsernames().toList();
            ms.pushPose();
            ms.translate(1.0f, 1.0f, 0.0f);
            ms.scale(0.4375f, 0.4375f, 1.0f);
            int i = 0;
            for (String name : playerNames) {
                if (i >= 4) break;
                PlayerInfo playerInfo = connection.getPlayerInfo(name);
                if (playerInfo == null) continue;
                PlayerFaceRenderer.draw((GuiGraphics)graphics, (PlayerSkin)playerInfo.getSkin(), (int)(16 * (i % 2)), (int)(16 * (i / 2)), (int)16);
                ++i;
            }
            ms.popPose();
        }
    }

    public record Provider(String teamName) implements ITeam.Provider
    {
        public static final MapCodec<Provider> CODEC = CodecHelper.singleFieldMap(Codec.STRING, "team", Provider::teamName, Provider::new);
        public static final StreamCodec<FriendlyByteBuf, Provider> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, Provider::teamName, Provider::new);

        @Override
        public ITeam provideTeam(Level level) {
            return Petrolpark.SCOREBOARD_TEAMS.get(level, this.teamName).orElse(NoTeam.INSTANCE);
        }

        @Override
        public ITeam.ProviderType getProviderType() {
            return (ITeam.ProviderType)PetrolparkTeamProviderTypes.SCOREBOARD.get();
        }
    }
}

