/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.team.singleplayer;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.petrolpark.PetrolparkAttachmentTypes;
import com.petrolpark.PetrolparkTeamProviderTypes;
import com.petrolpark.core.team.AbstractTeam;
import com.petrolpark.core.team.ITeam;
import com.petrolpark.core.team.NoTeam;
import com.petrolpark.core.team.singleplayer.SinglePlayerTeamComponentChangedPacket;
import com.petrolpark.util.CodecHelper;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.PlayerFaceRenderer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.attachment.IAttachmentSerializer;
import org.jetbrains.annotations.Nullable;

public class SinglePlayerTeam
extends AbstractTeam {
    public final Player player;
    public static final IAttachmentSerializer<Tag, SinglePlayerTeam> ATTACHMENT_SERIALIZER = new IAttachmentSerializer<Tag, SinglePlayerTeam>(){

        public SinglePlayerTeam read(@Nonnull IAttachmentHolder holder, @Nonnull Tag tag, @Nonnull HolderLookup.Provider provider) {
            if (!(holder instanceof Player)) {
                throw new IllegalArgumentException(holder.toString() + " is not a Player");
            }
            Player player = (Player)holder;
            return new SinglePlayerTeam(player, (DataComponentPatch)DataComponentPatch.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag).getOrThrow());
        }

        @Nullable
        public Tag write(@Nonnull SinglePlayerTeam attachment, @Nonnull HolderLookup.Provider provider) {
            return attachment.writeDataComponentsTag();
        }
    };

    public static ITeam.Provider provider(Player player) {
        return new Provider(player.getUUID());
    }

    public static final SinglePlayerTeam create(IAttachmentHolder attachmentHolder) {
        if (attachmentHolder instanceof Player) {
            Player player = (Player)attachmentHolder;
            return new SinglePlayerTeam(player, DataComponentPatch.EMPTY);
        }
        throw new IllegalStateException(attachmentHolder.toString() + " is not a Player");
    }

    public static final ITeam get(Player player) {
        return SinglePlayerTeam.provider(player).provideTeam(player.level());
    }

    protected SinglePlayerTeam(Player player, DataComponentPatch components) {
        super(components);
        this.player = player;
    }

    @Override
    public ITeam.Provider getProvider() {
        return SinglePlayerTeam.provider(this.player);
    }

    @Override
    public boolean isMember(Player player) {
        return player.equals((Object)this.player);
    }

    @Override
    public int memberCount() {
        return 1;
    }

    @Override
    public Stream<String> streamMemberUsernames() {
        return Stream.of(this.player.getGameProfile().getName());
    }

    @Override
    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public Stream<Player> streamMembers() {
        return Stream.of(this.player);
    }

    @Override
    public boolean isAdmin(Player player) {
        return true;
    }

    @Override
    public Component getName() {
        return this.player.getName();
    }

    @Override
    public void setChanged(DataComponentPatch patch) {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CatnipServices.NETWORK.sendToClient(serverPlayer, (CustomPacketPayload)new SinglePlayerTeamComponentChangedPacket(patch));
        }
    }

    @Override
    public void renderIcon(GuiGraphics graphics) {
        Minecraft mc = Minecraft.getInstance();
        if (this.player == null) {
            return;
        }
        PlayerFaceRenderer.draw((GuiGraphics)graphics, (PlayerSkin)mc.getSkinManager().getInsecureSkin(this.player.getGameProfile()), (int)0, (int)0, (int)16);
    }

    @Override
    public Component getRenderedMemberList(int maxTextWidth) {
        return this.player.getName();
    }

    public record Provider(UUID playerUUID) implements ITeam.Provider
    {
        public static final MapCodec<Provider> CODEC = CodecHelper.singleFieldMap(UUIDUtil.CODEC, "player", Provider::playerUUID, Provider::new);
        public static final StreamCodec<FriendlyByteBuf, Provider> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, Provider::playerUUID, Provider::new);

        @Override
        public ITeam provideTeam(Level level) {
            Player player = level.getPlayerByUUID(this.playerUUID);
            if (player != null) {
                return (ITeam)player.getData(PetrolparkAttachmentTypes.SINGLE_PLAYER_TEAM_COMPONENTS.get());
            }
            return NoTeam.INSTANCE;
        }

        @Override
        public ITeam.ProviderType getProviderType() {
            return (ITeam.ProviderType)PetrolparkTeamProviderTypes.SINGLE_PLAYER.get();
        }
    }
}

