/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.mixin;

import com.petrolpark.config.PetrolparkConfigs;
import com.petrolpark.core.recipe.book.IRecipeBookProviderBlock;
import com.petrolpark.core.recipe.book.RecipeBookItem;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChiseledBookShelfBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={ChiseledBookShelfBlock.class})
public abstract class ChiseledBookShelfBlockMixin
extends BaseEntityBlock
implements IRecipeBookProviderBlock {
    protected ChiseledBookShelfBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
        throw new AssertionError();
    }

    @Override
    public boolean providesRecipeBook(RecipeHolder<?> recipeHolder, Level level, BlockPos pos, BlockState state) {
        if (!((Boolean)PetrolparkConfigs.server().chiseledBookShelfProvidesRecipeBooks.get()).booleanValue()) {
            return false;
        }
        return level.getBlockEntity(pos, BlockEntityType.CHISELED_BOOKSHELF).map(be -> be.hasAnyMatching(stack -> RecipeBookItem.streamProvidedRecipes(level, stack).anyMatch(arg_0 -> ((RecipeHolder)recipeHolder).equals(arg_0)))).orElse(false);
    }

    @Override
    public Stream<RecipeHolder<?>> streamProvidedRecipeBooks(Level level, BlockPos pos, BlockState state) {
        if (!((Boolean)PetrolparkConfigs.server().chiseledBookShelfProvidesRecipeBooks.get()).booleanValue()) {
            return Stream.empty();
        }
        return level.getBlockEntity(pos, BlockEntityType.CHISELED_BOOKSHELF).map(be -> IntStream.range(0, 6).mapToObj(arg_0 -> ((ChiseledBookShelfBlockEntity)be).getItem(arg_0)).flatMap(stack -> RecipeBookItem.streamProvidedRecipes(level, stack))).orElse(Stream.empty());
    }

    @Override
    public boolean shouldHighlightConnectedRecipeBookAcceptors(Level level, BlockPos pos, BlockState state) {
        return (Boolean)PetrolparkConfigs.server().chiseledBookShelfProvidesRecipeBooks.get();
    }
}

