/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.petrolpark.PetrolparkRecipeTypes;
import com.petrolpark.core.recipe.book.IBookRequiredRecipe;
import java.util.Optional;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CrafterMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={CrafterMenu.class})
public class CrafterMenuMixin {
    @Shadow
    private CraftingContainer container;
    @Shadow
    private Player player;

    @ModifyExpressionValue(method={"refreshRecipeResult"}, at={@At(value="INVOKE", target="getPotentialResults")})
    public Optional<RecipeHolder<CraftingRecipe>> modifyGetPotentialResults(Optional<RecipeHolder<CraftingRecipe>> original) {
        CraftingContainer craftingContainer = this.container;
        if (!(craftingContainer instanceof BlockEntity)) {
            return original;
        }
        BlockEntity be = (BlockEntity)craftingContainer;
        return original.or(() -> this.player.level().getRecipeManager().getRecipeFor((RecipeType)PetrolparkRecipeTypes.CRAFTING_BOOK_REQUIRED.get(), (RecipeInput)this.container.asCraftInput(), this.player.level()).filter(rh -> IBookRequiredRecipe.hasRequiredBook(be, rh)).map(rh -> new RecipeHolder(rh.id(), (Recipe)((CraftingRecipe)rh.value()))));
    }
}

