/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.mixin;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.mojang.authlib.GameProfile;
import com.petrolpark.core.inventory.extended.ExtendedInventory;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity {
    @Shadow
    private Inventory inventory;

    protected PlayerMixin(EntityType<? extends LivingEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        throw new AssertionError();
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void inInit(Level level, BlockPos pos, float yRot, GameProfile gameProfile, CallbackInfo ci) {
        if (ExtendedInventory.enabled(level.enabledFeatures())) {
            ExtendedInventory extendedInv = new ExtendedInventory((Player)this);
            this.inventory = extendedInv;
            ExtendedInventory.refreshPlayerInventoryMenuServer((Player)this);
        }
    }

    @WrapMethod(method={"setItemSlot"})
    public void inSetItemSlot(EquipmentSlot slot, ItemStack stack, Operation<Void> original) {
        Optional<ExtendedInventory> invOp;
        if (slot == EquipmentSlot.MAINHAND && (invOp = ExtendedInventory.get((Player)this)).isPresent()) {
            this.verifyEquippedItem(stack);
            ExtendedInventory inv = invOp.get();
            ItemStack oldStack = inv.getItem(inv.selected);
            inv.setItem(inv.selected, stack);
            this.onEquipItem(slot, oldStack, stack);
        }
        original.call(new Object[]{slot, stack});
    }
}

