/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.mixin;

import com.petrolpark.core.block.entity.IShulkerBoxBlockEntityDuck;
import com.petrolpark.core.contamination.Contaminant;
import com.petrolpark.core.contamination.GenericContamination;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ShulkerBoxBlockEntity.class})
public abstract class ShulkerBoxBlockEntityMixin
extends RandomizableContainerBlockEntity
implements IShulkerBoxBlockEntityDuck {
    @Unique
    private GenericContamination contamination;

    protected ShulkerBoxBlockEntityMixin(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        throw new AssertionError();
    }

    @Override
    public GenericContamination getContamination() {
        if (this.contamination == null) {
            this.contamination = new GenericContamination();
        }
        return this.contamination;
    }

    @Override
    public void contaminateAll(Stream<Holder<Contaminant>> contaminants) {
        this.contamination.contaminateAll(contaminants);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void inInit(CallbackInfo ci) {
        this.getContamination();
    }

    @Inject(method={"loadFromTag"}, at={@At(value="HEAD")})
    public void inLoadFromTag(CompoundTag tag, HolderLookup.Provider levelRegistry, CallbackInfo ci) {
        this.contamination = new GenericContamination().readNBT(tag.get("Contamination"), levelRegistry);
    }

    @Inject(method={"saveAdditional"}, at={@At(value="HEAD")})
    public void inSaveAdditional(CompoundTag tag, HolderLookup.Provider levelRegistry, CallbackInfo ci) {
        tag.put("Contamination", this.getContamination().writeNBT(levelRegistry));
    }
}

