/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.petrolpark.core.block.entity.IShulkerBoxBlockEntityDuck;
import com.petrolpark.core.contamination.GenericContamination;
import com.petrolpark.core.contamination.ItemContamination;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={ShulkerBoxBlock.class})
public abstract class ShulkerBoxBlockMixin
extends BaseEntityBlock {
    protected ShulkerBoxBlockMixin(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        throw new AssertionError();
    }

    @ModifyReturnValue(method={"getDrops"}, at={@At(value="RETURN")})
    public List<ItemStack> modifyGetDrops(List<ItemStack> original, BlockState state, LootParams.Builder params) {
        BlockEntity be = (BlockEntity)params.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (be instanceof ShulkerBoxBlockEntity) {
            ShulkerBoxBlockEntity shulkerBox = (ShulkerBoxBlockEntity)be;
            GenericContamination contamination = ((IShulkerBoxBlockEntityDuck)shulkerBox).getContamination();
            original.stream().filter(s -> {
                BlockItem b;
                Item patt0$temp = s.getItem();
                return patt0$temp instanceof BlockItem && (b = (BlockItem)patt0$temp).getBlock() == this;
            }).map(ItemContamination::get).forEach(contam -> contam.contaminateAll(contamination.streamOrphanExtrinsicContaminants()));
        }
        return original;
    }

    public void setPlacedBy(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity placer, @Nonnull ItemStack stack) {
        level.getBlockEntity(pos, BlockEntityType.SHULKER_BOX).map(IShulkerBoxBlockEntityDuck.class::cast).ifPresent(duck -> duck.contaminateAll(ItemContamination.get(stack).streamOrphanExtrinsicContaminants()));
    }
}

