/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.mixin.compat.create;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.petrolpark.compat.create.core.recipe.firsttimelucky.FTLRecipesBehaviour;
import com.petrolpark.compat.create.core.recipe.firsttimelucky.IFTLProcessingRecipe;
import com.petrolpark.config.PetrolparkConfigs;
import com.petrolpark.core.contamination.IContamination;
import com.petrolpark.core.contamination.ItemContamination;
import com.petrolpark.core.item.decay.ItemDecay;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.millstone.MillingRecipe;
import com.simibubi.create.content.kinetics.millstone.MillstoneBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MillstoneBlockEntity.class}, remap=false)
public abstract class MillstoneBlockEntityMixin
extends KineticBlockEntity {
    @Unique
    ItemStack lastItemProcessed;
    @Shadow
    public ItemStackHandler inputInv;
    @Shadow
    public ItemStackHandler outputInv;

    public MillstoneBlockEntityMixin(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        throw new AssertionError();
    }

    @Inject(method={"Lcom/simibubi/create/content/kinetics/millstone/MillstoneBlockEntity;addBehaviours(Ljava/util/List;)V"}, at={@At(value="RETURN")}, remap=false)
    public void inAddBehaviours(List<BlockEntityBehaviour> behaviours, CallbackInfo ci) {
        behaviours.add(new FTLRecipesBehaviour((SmartBlockEntity)this, rh -> rh.value().getType() == AllRecipeTypes.MILLING.getType()));
    }

    @Inject(method={"Lcom/simibubi/create/content/kinetics/millstone/MillstoneBlockEntity;process()V"}, at={@At(value="HEAD")}, remap=false)
    public void inProcessStart(CallbackInfo ci) {
        this.lastItemProcessed = this.inputInv.getStackInSlot(0).copy();
    }

    @WrapOperation(method={"Lcom/simibubi/create/content/kinetics/millstone/MillstoneBlockEntity;process()V"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/kinetics/millstone/MillingRecipe;rollResults(Lnet/minecraft/util/RandomSource;)Ljava/util/List;")}, remap=false)
    public List<ItemStack> wrapRollResults(MillingRecipe recipe, RandomSource random, Operation<List<ItemStack>> original) {
        List results;
        if (recipe instanceof IFTLProcessingRecipe) {
            IFTLProcessingRecipe ftlr = (IFTLProcessingRecipe)recipe;
            results = ftlr.rollLuckyResults((SmartBlockEntity)this, random);
        } else {
            results = (List)original.call(new Object[]{recipe, random});
        }
        if (((Boolean)PetrolparkConfigs.server().createCrushingRecipesPropagateContaminants.get()).booleanValue() && this.lastItemProcessed != null) {
            IContamination<?, ?> inputContamination = ItemContamination.get(this.lastItemProcessed);
            Level level = this.getLevel();
            if (level != null) {
                results.stream().map(ItemContamination::get).forEach(c -> c.contaminateAll(inputContamination.streamAllContaminants()));
            }
        }
        results.forEach(ItemDecay::startDecay);
        return results;
    }
}

