/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.mixin.compat.create;

import com.petrolpark.config.PetrolparkConfigs;
import com.petrolpark.core.contamination.IContamination;
import com.petrolpark.core.contamination.ItemContamination;
import com.petrolpark.core.item.decay.ItemDecay;
import com.simibubi.create.content.kinetics.base.BlockBreakingKineticBlockEntity;
import com.simibubi.create.content.kinetics.saw.SawBlockEntity;
import com.simibubi.create.content.processing.recipe.ProcessingInventory;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={SawBlockEntity.class}, remap=false)
public abstract class SawBlockEntityMixin
extends BlockBreakingKineticBlockEntity {
    @Shadow
    public ProcessingInventory inventory;
    @Unique
    ItemStack petrolpark$lastItemProcessed;

    public SawBlockEntityMixin(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        throw new AssertionError();
    }

    @Inject(method={"applyRecipe()V"}, at={@At(value="HEAD")}, remap=false)
    public void inApplyRecipeStart(CallbackInfo ci) {
        this.petrolpark$lastItemProcessed = this.inventory.getStackInSlot(0);
    }

    @Inject(method={"applyRecipe()V"}, at={@At(value="RETURN")}, locals=LocalCapture.CAPTURE_FAILSOFT, remap=false)
    public void inApplyRecipeEnd(CallbackInfo ci, ItemStack input, List<? extends Recipe<?>> recipes) {
        if (recipes.isEmpty()) {
            return;
        }
        IContamination<?, ?> inputContamination = ItemContamination.get(this.petrolpark$lastItemProcessed);
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            ItemStack stack = this.inventory.getStackInSlot(slot);
            ItemDecay.startDecay(stack);
            Level level = this.getLevel();
            if (level == null || !((Boolean)PetrolparkConfigs.server().createCuttingRecipesPropagateContaminants.get()).booleanValue()) continue;
            ItemContamination.get(stack).contaminateAll(inputContamination.streamAllContaminants());
        }
    }
}

