/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.util;

import java.text.DecimalFormat;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.ai.gossip.GossipType;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.Rarity;
import net.neoforged.neoforge.common.Tags;
import org.spongepowered.include.com.google.common.base.Strings;

public class Lang {
    public static final DecimalFormat INT_DF = new DecimalFormat();
    private static final Set<Collector.Characteristics> COMPONENT_COLLECTOR_CHARACTERISTICS;

    public static String asId(String string) {
        return string.toLowerCase(Locale.ROOT);
    }

    public static Component shortList(List<? extends Component> elements, int maxTextWidth) {
        return Lang.shortList(elements, maxTextWidth, Minecraft.getInstance().font);
    }

    public static Component shortList(List<? extends Component> elements, int maxTextWidth, Font font) {
        Component list;
        Component namedList;
        if (elements.isEmpty()) {
            return Component.translatable((String)"petrolpark.generic.list.none");
        }
        if (elements.size() == 1) {
            return elements.get(0);
        }
        int namedElements = 1;
        Component extendedList = namedList = elements.get(0);
        do {
            list = extendedList;
            Component nextElement = elements.get(namedElements);
            if (++namedElements < elements.size()) {
                namedList = Component.translatable((String)"petrolpark.generic.list.comma", (Object[])new Object[]{namedList, nextElement});
                extendedList = Component.translatable((String)"petrolpark.generic.list.and_more", (Object[])new Object[]{namedList, elements.size() - namedElements});
                continue;
            }
            extendedList = Component.translatable((String)"petrolpark.generic.list.and", (Object[])new Object[]{namedList, nextElement});
        } while (font.width((FormattedText)extendedList) < maxTextWidth && namedElements < elements.size());
        list = extendedList;
        return list;
    }

    public static String shortList(String[] elements) {
        String list;
        String namedList;
        if (elements.length == 0) {
            return Component.translatable((String)"petrolpark.generic.list.none").getString();
        }
        if (elements.length == 1) {
            return elements[0];
        }
        int namedElements = 1;
        String extendedList = namedList = elements[0];
        do {
            list = extendedList;
            String nextElement = elements[namedElements];
            if (++namedElements < elements.length) {
                namedList = Component.translatable((String)"petrolpark.generic.list.comma", (Object[])new Object[]{namedList, nextElement}).getString();
                extendedList = Component.translatable((String)"petrolpark.generic.list.and_more", (Object[])new Object[]{namedList, elements.length - namedElements}).getString();
                continue;
            }
            extendedList = Component.translatable((String)"petrolpark.generic.list.and", (Object[])new Object[]{namedList, nextElement}).getString();
        } while (namedElements < elements.length);
        list = extendedList;
        return list;
    }

    protected static Component generic(String keyEnd, Object ... translationArgs) {
        return Component.translatable((String)("petrolpark.generic." + keyEnd), (Object[])translationArgs);
    }

    public static Component none() {
        return Lang.generic("list.none", new Object[0]);
    }

    public static Component rarity(Rarity rarity) {
        return Lang.generic("rarity." + rarity.getSerializedName(), new Object[0]);
    }

    public static Component direction(Direction direction) {
        return Lang.generic("direction." + direction.getName(), new Object[0]);
    }

    public static Component clickType(ClickType clickType, int slot) {
        return Lang.generic("click_type." + Lang.asId(clickType.name()), slot);
    }

    public static Component hand(InteractionHand hand) {
        return Lang.generic("hand." + Lang.asId(hand.name()), new Object[0]);
    }

    public static Component action(ServerboundPlayerActionPacket.Action action, BlockPos pos) {
        return Lang.generic("action." + Lang.asId(action.name()), pos.toShortString());
    }

    public static Component enabled(boolean enabled) {
        return enabled ? Lang.generic("enabled", new Object[0]) : Lang.generic("disabled", new Object[0]);
    }

    public static Component gossipType(GossipType type) {
        return Lang.generic("gossip_type." + type.name(), new Object[0]);
    }

    public static Component tag(TagKey<?> tagKey) {
        String tagTranslationKey = Tags.getTagTranslationKey(tagKey);
        return Component.translatableWithFallback((String)tagTranslationKey, (String)("#" + String.valueOf(tagKey.location())));
    }

    public static Component loot(ResourceLocation id) {
        return Component.translatableWithFallback((String)Util.makeDescriptionId((String)"loot_table", (ResourceLocation)id), (String)String.valueOf(id));
    }

    public static Component unknownRange() {
        return Lang.generic("range.unknown", new Object[0]);
    }

    public static Component range(float min, float max, DecimalFormat df) {
        return Lang.range(min, max, false, df);
    }

    public static Component range(float min, float max, boolean approximate, DecimalFormat df) {
        String[] args;
        Object postfix;
        if (min == Float.NaN) {
            if (max == Float.NaN) {
                return Lang.unknownRange();
            }
            postfix = "range.at_most";
            args = new String[]{df.format(max)};
        } else if (max == Float.NaN) {
            postfix = "range.at_least";
            args = new String[]{df.format(min)};
        } else {
            postfix = "range";
            args = new String[]{df.format(min), df.format(max)};
        }
        if (approximate) {
            postfix = (String)postfix + ".approximate";
        }
        return Lang.generic((String)postfix, args);
    }

    public static final Collector<Component, MutableComponent, Component> toComponent() {
        return Lang.toComponent((Component)Component.literal((String)" "));
    }

    public static Collector<Component, MutableComponent, Component> toComponent(final Component joiner) {
        return new Collector<Component, MutableComponent, Component>(){

            @Override
            public BiConsumer<MutableComponent, Component> accumulator() {
                return (mutableComponent, component) -> mutableComponent.append(joiner).append(component);
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return COMPONENT_COLLECTOR_CHARACTERISTICS;
            }

            @Override
            public BinaryOperator<MutableComponent> combiner() {
                return (component1, component2) -> component1.append(joiner).append((Component)component2);
            }

            @Override
            public Function<MutableComponent, Component> finisher() {
                return component -> component;
            }

            @Override
            public Supplier<MutableComponent> supplier() {
                return Component::empty;
            }
        };
    }

    static {
        INT_DF.setMinimumFractionDigits(0);
        INT_DF.setMaximumFractionDigits(0);
        COMPONENT_COLLECTOR_CHARACTERISTICS = Set.of(Collector.Characteristics.IDENTITY_FINISH);
    }

    public static class IndentedTooltipBuilder {
        protected List<Component> components;
        protected int indents = 0;

        public IndentedTooltipBuilder(List<Component> components) {
            this.components = components;
        }

        public IndentedTooltipBuilder indent() {
            ++this.indents;
            return this;
        }

        public IndentedTooltipBuilder unindent() {
            --this.indents;
            return this;
        }

        public IndentedTooltipBuilder add(Component component) {
            this.components.add(this.withIndent(component));
            return this;
        }

        public IndentedTooltipBuilder addAll(Stream<Component> components) {
            this.components.addAll(components.map(this::withIndent).toList());
            return this;
        }

        protected Component withIndent(Component unindentedComponent) {
            return Component.literal((String)Strings.repeat((String)" ", (int)this.indents)).append(unindentedComponent);
        }
    }
}

