/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.util;

import com.petrolpark.util.ISequenceBiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public abstract class NestedSequenceBiMap<K, V>
implements ISequenceBiMap<K, V, List<K>, Entry<K, V>, NestedSequenceBiMap<K, V>> {
    protected abstract Map<K, Entry<K, V>> getEntryMap();

    @Override
    public final Entry<K, V> get(K key) {
        return this.getEntryMap().get(key);
    }

    @Override
    public final Entry<K, V> get(List<K> sequence) {
        Iterator<K> iterator = sequence.iterator();
        NestedSequenceBiMap map = this;
        ISequenceBiMap.IEntry entry = null;
        while (iterator.hasNext()) {
            K key = iterator.next();
            entry = map.get((Object)key);
            if (entry != null && entry.asMap().isPresent()) {
                map = (NestedSequenceBiMap)entry.asMap().get();
                continue;
            }
            if (!iterator.hasNext()) continue;
            return null;
        }
        return entry;
    }

    @Override
    public final V follow(List<K> sequence) {
        Iterator<K> iterator = sequence.iterator();
        NestedSequenceBiMap map = this;
        if (iterator.hasNext()) {
            K key = iterator.next();
            iterator.remove();
            ISequenceBiMap.IEntry entry = map.get((Object)key);
            if (entry == null) {
                return null;
            }
            if (entry.asValue().isPresent()) {
                return entry.asValue().get();
            }
            if (entry.asMap().isPresent()) {
                map = (NestedSequenceBiMap)entry.asMap().get();
            }
            throw new IllegalStateException("Entry is neither a value nor a sub-map");
        }
        return null;
    }

    @Override
    public final List<K> getKeySequence(V value) {
        return (List)this.getKeySequenceMap().get(value);
    }

    @Override
    public final Collection<V> values() {
        return this.getKeySequenceMap().keySet();
    }

    protected static <K, V> void populateSequenceMap(Map<V, List<K>> sequenceMap, Entry<K, V> entry, List<K> sequence) {
        entry.asValue().ifPresent(value -> sequenceMap.put(value, sequence));
        entry.asMap().ifPresent(map -> map.getEntryMap().forEach((key, subEntry) -> {
            ArrayList<Object> subSequence = new ArrayList<Object>(sequence.size() + 1);
            subSequence.addAll(sequence);
            subSequence.add(key);
            NestedSequenceBiMap.populateSequenceMap(sequenceMap, subEntry, subSequence);
        }));
    }

    public static sealed interface Entry<K, V>
    extends ISequenceBiMap.IEntry<K, V, List<K>, Entry<K, V>, NestedSequenceBiMap<K, V>> {

        public record SubMapEntry<K, V>(NestedSequenceBiMap<K, V> subMap) implements Entry<K, V>
        {
            @Override
            public Optional<? extends V> asValue() {
                return Optional.empty();
            }

            @Override
            public Optional<NestedSequenceBiMap<K, V>> asMap() {
                return Optional.ofNullable(this.subMap);
            }
        }

        public record ValueEntry<K, V>(V value) implements Entry<K, V>
        {
            @Override
            public Optional<? extends V> asValue() {
                return Optional.ofNullable(this.value);
            }

            @Override
            public Optional<NestedSequenceBiMap<K, V>> asMap() {
                return Optional.empty();
            }
        }
    }
}

