/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.util;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class RayHelper {
    public static HitResult getHitResult(Entity entity, float partialTicks, boolean hitFluids) {
        return RayHelper.getHitResult(Collections.emptyList(), entity, partialTicks, hitFluids);
    }

    public static HitResult getHitResult(List<AABB> customBoxes, Entity entity, float partialTicks, boolean hitFluids) {
        AABB aabb;
        Vec3 view;
        Vec3 ray;
        EntityHitResult entityHitResult;
        double squareReach;
        double blockHitReach = RayHelper.getBlockReach(entity);
        double entityHitReach = RayHelper.getEntityReach(entity);
        double reach = Math.max(blockHitReach, entityHitReach);
        HitResult result = entity.pick(reach, partialTicks, hitFluids);
        Vec3 eyePos = entity.getEyePosition();
        double squareHitDistance = squareReach = reach * reach;
        if (result != null && result.getType() != HitResult.Type.MISS) {
            Vec3 blockHitLocation = result.getLocation();
            squareReach = blockHitLocation.distanceToSqr(eyePos);
            if (squareReach > blockHitReach * blockHitReach) {
                result = BlockHitResult.miss((Vec3)blockHitLocation, (Direction)Direction.getNearest((double)eyePos.x, (double)eyePos.y, (double)eyePos.z), (BlockPos)BlockPos.containing((Position)blockHitLocation));
            } else {
                squareHitDistance = squareReach;
            }
        }
        if ((entityHitResult = ProjectileUtil.getEntityHitResult((Entity)entity, (Vec3)eyePos, (Vec3)(ray = eyePos.add((view = entity.getViewVector(partialTicks)).scale(reach))), (AABB)(aabb = entity.getBoundingBox().expandTowards(view.scale(reach)).inflate(1.0, 1.0, 1.0)), e -> !e.isSpectator() && e.isPickable(), (double)squareReach)) != null) {
            Vec3 entityHitLocation = entityHitResult.getLocation();
            double squareEntityDistance = eyePos.distanceToSqr(entityHitLocation);
            if (squareEntityDistance > squareReach || squareEntityDistance > entityHitReach * entityHitReach) {
                result = BlockHitResult.miss((Vec3)entityHitLocation, (Direction)Direction.getNearest((double)view.x, (double)view.y, (double)view.z), (BlockPos)BlockPos.containing((Position)entityHitLocation));
            } else if (squareEntityDistance < squareReach || result == null) {
                result = entityHitResult;
                squareHitDistance = squareEntityDistance;
            }
        }
        int i = 0;
        for (AABB box : customBoxes) {
            Vec3 customBoxHitLocation;
            double customBoxDistanceSquare;
            Optional hit = box.clip(eyePos, ray);
            if (hit.isPresent() && (customBoxDistanceSquare = eyePos.distanceToSqr(customBoxHitLocation = (Vec3)hit.get())) < squareHitDistance) {
                result = new CustomHitResult(customBoxHitLocation, i);
                squareHitDistance = customBoxDistanceSquare;
            }
            ++i;
        }
        return result;
    }

    public static double getBlockReach(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player.blockInteractionRange();
        }
        return 3.0;
    }

    public static double getEntityReach(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player.entityInteractionRange();
        }
        return 3.0;
    }

    public static int getHit(List<AABB> boxes, Vec3 start, Vec3 end) {
        int hit = -1;
        int boxNo = 0;
        double minimumDistance = Double.MAX_VALUE;
        for (AABB box : boxes) {
            double distance;
            if (box.contains(start)) {
                return boxNo;
            }
            Optional hitVec = box.clip(start, end);
            if (hitVec.isPresent() && (distance = start.distanceToSqr((Vec3)hitVec.get())) < minimumDistance) {
                hit = boxNo;
                minimumDistance = distance;
            }
            ++boxNo;
        }
        return hit;
    }

    public static class CustomHitResult
    extends HitResult {
        public final int index;

        protected CustomHitResult(Vec3 location, int index) {
            super(location);
            this.index = index;
        }

        public HitResult.Type getType() {
            return HitResult.Type.ENTITY;
        }
    }
}

