/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block;

import de.mrjulsen.crn.block.AbstractAdvancedDisplayBlock;
import de.mrjulsen.crn.block.properties.ESide;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class AbstractAdvancedSidedDisplayBlock
extends AbstractAdvancedDisplayBlock {
    public static final EnumProperty<ESide> SIDE = EnumProperty.create((String)"side", ESide.class);

    public AbstractAdvancedSidedDisplayBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(SIDE, (Comparable)((Object)ESide.FRONT)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{SIDE});
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction face = context.getClickedFace();
        BlockPos clickedPos = context.getClickedPos();
        BlockPos placedOnPos = clickedPos.relative(face.getOpposite());
        Level level = context.getLevel();
        BlockState otherState = level.getBlockState(placedOnPos);
        BlockState stateForPlacement = (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
        if (otherState.getBlock() != this || context.getPlayer() != null && context.getPlayer().isShiftKeyDown()) {
            stateForPlacement = this.getDefaultPlacementState(context, stateForPlacement, otherState);
            stateForPlacement = this.getPropertyFromNeighbours(stateForPlacement, level, clickedPos, SIDE);
        } else {
            stateForPlacement = this.appendOnPlace(context, stateForPlacement, otherState);
        }
        return this.updateColumn(level, clickedPos, stateForPlacement, true);
    }

    @Override
    public BlockState appendOnPlace(BlockPlaceContext context, BlockState state, BlockState other) {
        state = (BlockState)super.appendOnPlace(context, state, other).setValue(SIDE, (Comparable)((Object)((ESide)((Object)other.getValue(SIDE)))));
        return state;
    }
}

