/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block;

import com.simibubi.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.block.IBE;
import de.mrjulsen.crn.api.client.Screens;
import de.mrjulsen.crn.block.blockentity.NavigatorLecternBlockEntity;
import de.mrjulsen.crn.registry.ModBlockEntities;
import de.mrjulsen.crn.registry.ModItems;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class NavigatorLecternBlock
extends LecternBlock
implements IBE<NavigatorLecternBlockEntity>,
SpecialBlockItemRequirement {
    public NavigatorLecternBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)HAS_BOOK, (Comparable)Boolean.valueOf(true)));
    }

    public Class<NavigatorLecternBlockEntity> getBlockEntityClass() {
        return NavigatorLecternBlockEntity.class;
    }

    public BlockEntityType<? extends NavigatorLecternBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModBlockEntities.NAVIGATOR_LECTERN_BLOCK_ENTITY.get();
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return super.newBlockEntity(pos, state);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!player.isShiftKeyDown() && NavigatorLecternBlockEntity.playerInRange(player, level, pos)) {
            if (level.isClientSide) {
                Screens.showNavigatorScreen(null, true);
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (player.isShiftKeyDown()) {
            if (!level.isClientSide) {
                this.replaceWithLectern(state, level, pos);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!player.isShiftKeyDown() && NavigatorLecternBlockEntity.playerInRange(player, level, pos)) {
            if (level.isClientSide) {
                Screens.showNavigatorScreen(null, true);
            }
            return InteractionResult.SUCCESS;
        }
        if (player.isShiftKeyDown()) {
            if (!level.isClientSide) {
                this.replaceWithLectern(state, level, pos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            if (!world.isClientSide) {
                this.withBlockEntityDo((BlockGetter)world, pos, be -> be.dropController(state));
            }
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        return 15;
    }

    public void replaceLectern(BlockState lecternState, Level world, BlockPos pos, ItemStack controller) {
        world.setBlockAndUpdate(pos, (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)lecternState.getValue((Property)FACING)))).setValue((Property)POWERED, (Comparable)((Boolean)lecternState.getValue((Property)POWERED))));
        this.withBlockEntityDo((BlockGetter)world, pos, be -> be.setNavigator(controller));
    }

    public void replaceWithLectern(BlockState state, Level world, BlockPos pos) {
        world.setBlockAndUpdate(pos, (BlockState)((BlockState)Blocks.LECTERN.defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)POWERED, (Comparable)((Boolean)state.getValue((Property)POWERED))));
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return Blocks.LECTERN.getCloneItemStack(state, target, level, pos, player);
    }

    public ItemRequirement getRequiredItems(BlockState state, BlockEntity be) {
        ArrayList<ItemStack> requiredItems = new ArrayList<ItemStack>();
        requiredItems.add(new ItemStack((ItemLike)Blocks.LECTERN));
        requiredItems.add(new ItemStack((ItemLike)ModItems.NAVIGATOR.get()));
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, requiredItems);
    }
}

