/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import de.mrjulsen.crn.client.gui.Animator;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLWidgetContainer;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;

public abstract class AbstractNotificationPopup
extends DLWidgetContainer {
    protected final DLScreen screen;
    protected final CreateDynamicWidgets.ColorShade shade;
    protected final Animator animator = (Animator)this.addRenderableOnly((Renderable)new Animator());
    private final Consumer<GuiEventListener> removeWidgetFunc;
    private int xOffset;
    private int yOffset;
    private boolean isClosing = false;

    public AbstractNotificationPopup(DLScreen screen, int x, int y, int width, int height, CreateDynamicWidgets.ColorShade shade, Consumer<GuiEventListener> removeWidgetFunc) {
        super(x, y, width, height);
        this.screen = screen;
        this.shade = shade;
        this.removeWidgetFunc = removeWidgetFunc;
        this.animator.start(3, null, null, null);
    }

    public void close() {
        this.isClosing = true;
        this.animator.start(3, null, null, () -> this.removeWidgetFunc.accept((GuiEventListener)this));
    }

    public void closeImmediately() {
        this.isClosing = true;
        this.removeWidgetFunc.accept((GuiEventListener)this);
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.poseStack().pushPose();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        if (this.animator.isRunning()) {
            if (this.isClosing) {
                graphics.poseStack().translate(0.0f, this.animator.getCurrentTicksSmooth() * 2.0f, 0.0f);
                GuiUtils.setTint((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - this.animator.getPercentage()));
            } else {
                graphics.poseStack().translate(0.0f, (float)(this.animator.getTotalTicks() * 2) - this.animator.getCurrentTicksSmooth() * 2.0f, 0.0f);
                GuiUtils.setTint((float)1.0f, (float)1.0f, (float)1.0f, (float)this.animator.getPercentage());
            }
        }
        this.renderFlyout(graphics, mouseX, mouseY, partialTicks, GuiAreaDefinition.of((DLWidgetContainer)this));
        this.renderFlyoutContent(graphics, mouseX, mouseY, partialTicks, GuiAreaDefinition.of((DLWidgetContainer)this));
        graphics.poseStack().popPose();
    }

    public void renderFlyoutContent(Graphics graphics, int mouseX, int mouseY, float partialTicks, GuiAreaDefinition contentArea) {
        super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
    }

    public void renderFlyout(Graphics graphics, int mouseX, int mouseY, float partialTicks, GuiAreaDefinition contentArea) {
        CreateDynamicWidgets.renderShadow(graphics, contentArea.getX(), contentArea.getY(), contentArea.getWidth(), contentArea.getHeight());
        CreateDynamicWidgets.renderSingleShadeWidget(graphics, contentArea.getX(), contentArea.getY(), contentArea.getWidth(), contentArea.getHeight(), this.shade);
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        return NarratableEntry.NarrationPriority.HOVERED;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            this.close();
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public void setXOffset(int xOffset) {
        this.xOffset = xOffset;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public void setYOffset(int yOffset) {
        this.yOffset = yOffset;
    }

    public void updateNarration(NarrationElementOutput narrationElementOutput) {
    }

    public boolean consumeScrolling(double mouseX, double mouseY) {
        return true;
    }
}

