/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.navigation;

import com.google.common.collect.ImmutableMap;
import com.simibubi.create.content.trains.entity.Train;
import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.config.ModCommonConfig;
import de.mrjulsen.crn.data.StationTag;
import de.mrjulsen.crn.data.UserSettings;
import de.mrjulsen.crn.data.navigation.EdgeData;
import de.mrjulsen.crn.data.navigation.Node;
import de.mrjulsen.crn.data.navigation.Route;
import de.mrjulsen.crn.data.navigation.RoutePart;
import de.mrjulsen.crn.data.navigation.TrainSchedule;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.crn.data.train.ScheduleSection;
import de.mrjulsen.crn.data.train.TrainData;
import de.mrjulsen.crn.data.train.TrainListener;
import de.mrjulsen.crn.data.train.TrainPrediction;
import de.mrjulsen.crn.data.train.TrainUtils;
import de.mrjulsen.crn.event.ModCommonEvents;
import de.mrjulsen.crn.exceptions.RuntimeSideException;
import de.mrjulsen.mcdragonlib.data.Single;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;

public class NavigatableGraph {
    protected final UserSettings userSettings;
    protected final Map<StationTag, Node> nodesByTag = new HashMap<StationTag, Node>();
    protected final Map<UUID, Set<Node>> nodesByTrain = new HashMap<UUID, Set<Node>>();
    protected final Map<Node, Map<Node, Set<EdgeData>>> edgesByTag = new HashMap<Node, Map<Node, Set<EdgeData>>>();

    public NavigatableGraph(UserSettings userSettings) throws RuntimeSideException {
        if (!ModCommonEvents.hasServer()) {
            throw new RuntimeSideException(false);
        }
        this.userSettings = userSettings;
        long startTime = System.currentTimeMillis();
        Set trains = TrainListener.getAllTrains().stream().filter(x -> !this.globalSettings().isTrainBlacklisted((Train)x) && !this.globalSettings().isTrainExcludedByUser((Train)x, userSettings) && TrainUtils.isTrainUsable(x)).collect(Collectors.toSet());
        for (Train train : trains) {
            TrainListener.getTrainData(train).ifPresent(x -> this.addTrain(train, (TrainData)x));
        }
        if (((Boolean)ModCommonConfig.ADVANCED_LOGGING.get()).booleanValue()) {
            CreateRailwaysNavigator.LOGGER.info(String.format("Graph generated. Took %sms. Contains %s nodes and %s edges. %s train processed.", System.currentTimeMillis() - startTime, this.nodesByTag.size(), this.edgesByTag.values().stream().flatMap(x -> x.values().stream().flatMap(y -> y.stream())).count(), trains.size()));
        }
    }

    protected GlobalSettings globalSettings() {
        return GlobalSettings.getInstance();
    }

    protected void addTrain(Train train, TrainData data) {
        ConcurrentLinkedDeque<TrainPrediction> predictions = new ConcurrentLinkedDeque<TrainPrediction>(data.getPredictions());
        boolean singleSection = data.isSingleSection();
        if (predictions.isEmpty()) {
            return;
        }
        if (CreateRailwaysNavigator.isDebug()) {
            CreateRailwaysNavigator.LOGGER.info("\nEDGES FOR TRAIN: " + train.name.getString() + ", Single Section: " + singleSection + ", Sections Count: " + data.getSections().size());
        }
        StringBuilder sb = new StringBuilder();
        TrainPrediction lastPrediction = null;
        boolean nothingFound = true;
        boolean stationsRemoved = false;
        while (!predictions.isEmpty()) {
            TrainPrediction prediction = (TrainPrediction)predictions.peekLast();
            ScheduleSection section = prediction.getSection();
            if (!(!this.globalSettings().isStationBlacklisted(prediction.getTargetedStationName()) && (section.isUsable() || section.isFirstStop(prediction) && section.previousSection().isUsable() && section.previousSection().shouldIncludeNextStationOfNextSection()))) {
                predictions.removeLast();
                stationsRemoved = true;
                continue;
            }
            nothingFound = false;
            lastPrediction = prediction;
            break;
        }
        if (nothingFound || lastPrediction == null) {
            return;
        }
        Node lastNode = this.addNode(lastPrediction);
        TrainPrediction lastTrainPrediction = lastPrediction;
        if (CreateRailwaysNavigator.isDebug()) {
            sb.append(lastTrainPrediction.getStationTag().getTagName().get());
        }
        boolean noEdgePossible = false;
        while (!predictions.isEmpty()) {
            TrainPrediction prediction = (TrainPrediction)predictions.poll();
            if (!this.isPredictionAllowed(prediction)) {
                noEdgePossible = true;
                continue;
            }
            Node node = this.addNode(prediction);
            if (!noEdgePossible && !stationsRemoved && lastTrainPrediction.getSection().getScheduleIndex() == prediction.getSection().getScheduleIndex() || lastTrainPrediction.getSection().shouldIncludeNextStationOfNextSection()) {
                this.addEdge(lastNode, node, prediction);
                if (CreateRailwaysNavigator.isDebug()) {
                    sb.append(" ----- ");
                }
            } else if (CreateRailwaysNavigator.isDebug()) {
                sb.append(" >   < ");
            }
            lastNode = node;
            lastTrainPrediction = prediction;
            noEdgePossible = false;
            stationsRemoved = false;
            if (!CreateRailwaysNavigator.isDebug()) continue;
            sb.append(prediction.getStationTag().getTagName().get());
        }
        if (CreateRailwaysNavigator.isDebug()) {
            CreateRailwaysNavigator.LOGGER.info(sb.toString());
        }
    }

    protected boolean isPredictionAllowed(TrainPrediction prediction) {
        ScheduleSection section = prediction.getSection();
        boolean usable = section.isUsable() || section.isFirstStop(prediction) && section.previousSection().isUsable() && section.previousSection().shouldIncludeNextStationOfNextSection();
        return !this.globalSettings().isStationBlacklisted(prediction.getTargetedStationName()) && prediction.getSection().getTrainCategory().map(x -> !this.userSettings.navigationExcludedTrainCategories.getValue().contains(x.getId())).orElse(true) != false && usable;
    }

    protected Node addNode(TrainPrediction prediction) {
        StationTag tag = prediction.getStationTag();
        Node node = this.nodesByTag.computeIfAbsent(tag, x -> new Node(prediction));
        this.nodesByTrain.computeIfAbsent(prediction.getData().getTrainId(), x -> new HashSet()).add(node);
        node.addTrain(prediction);
        return node;
    }

    protected void addEdge(Node first, Node second, TrainPrediction prediction) {
        if (first == second) {
            return;
        }
        this.edgesByTag.computeIfAbsent(first, x -> new HashMap()).computeIfAbsent(second, x -> new HashSet()).add(new EdgeData(first, second, prediction));
    }

    protected Map<StationTag, Node> dijkstra(StationTag start, boolean avoidTransfers) {
        this.nodesByTag.values().forEach(x -> x.init());
        Node startNode = this.nodesByTag.get(start);
        startNode.setConnection(startNode, null, 0L);
        startNode.setTransferPoint(true);
        PriorityQueue<Node> queue = new PriorityQueue<Node>();
        HashMap<StationTag, Node> excludedNodes = new HashMap<StationTag, Node>();
        queue.add(startNode);
        while (!queue.isEmpty()) {
            Node currentNode = (Node)queue.poll();
            Map<Node, Set<EdgeData>> reachableNodes = this.edgesByTag.get(currentNode);
            if (reachableNodes != null) {
                reachableNodes.entrySet().stream().filter(x -> !excludedNodes.containsKey(((Node)x.getKey()).getStationTag())).forEach(y -> {
                    Node targetNode = (Node)y.getKey();
                    ((Set)y.getValue()).forEach(x -> {
                        EdgeData viaEdge = x;
                        Node.EdgeConnection connection = currentNode.selectBestConnectionFor(targetNode, viaEdge);
                        boolean isTransfer = connection != null && !connection.edge().connected(viaEdge);
                        long newCost = currentNode.getCost() + viaEdge.getCost() + (long)(isTransfer && avoidTransfers ? (Integer)ModCommonConfig.TRANSFER_COST.get() : 0);
                        targetNode.setConnection(currentNode, viaEdge, newCost);
                    });
                    queue.add(targetNode);
                });
            }
            excludedNodes.put(currentNode.getStationTag(), currentNode);
        }
        return excludedNodes;
    }

    protected Node dijkstraProcessor(Map<StationTag, Node> nodes, StationTag start, StationTag end) {
        Node prevNode;
        if (nodes.size() <= 1 || !nodes.containsKey(end) || !nodes.containsKey(start)) {
            return null;
        }
        Node currentNode = nodes.get(end);
        while (!currentNode.getStationTag().equals(start) && (prevNode = currentNode.getPreviousNode()) != null && currentNode != prevNode) {
            prevNode.setNextNode(currentNode);
            currentNode = prevNode;
        }
        return currentNode;
    }

    public List<Node> searchRoute(StationTag start, StationTag end, boolean avoidTransfers) {
        if (!this.nodesByTag.containsKey(start) || !this.nodesByTag.containsKey(end)) {
            return List.of();
        }
        Node startNode = this.dijkstraProcessor(this.dijkstra(start, avoidTransfers), start, end);
        if (CreateRailwaysNavigator.isDebug()) {
            StringBuilder sb = new StringBuilder("Dijkstra Nodes: ");
            for (Node node = startNode; node != null; node = node.getNextNode()) {
                sb.append(node.getStationTag().getTagName().get() + " > ");
            }
            CreateRailwaysNavigator.LOGGER.info(sb.toString());
        }
        if (startNode == null) {
            return List.of();
        }
        startNode.setTransferPoint(true);
        ArrayList<Node> route = new ArrayList<Node>();
        Node currentNode = startNode;
        while (!currentNode.getStationTag().equals(end)) {
            Node pNode;
            route.add(currentNode);
            Single.MutableSingle nextNode = new Single.MutableSingle((Object)currentNode.getNextNode());
            ArrayList<Node.EdgeConnection> connections = new ArrayList<Node.EdgeConnection>(currentNode.getNextConnections().stream().filter(x -> x.edge().getSecondNode().equals(nextNode.getFirst())).toList());
            while (nextNode.getFirst() != null && connections != null && !connections.isEmpty() && (pNode = ((Node)nextNode.getFirst()).getNextNode()) != null) {
                List<Node.EdgeConnection> pConnections = ((Node)nextNode.getFirst()).getNextConnections().stream().filter(x -> x.edge().getSecondNode().equals(pNode)).toList();
                connections.removeIf(x -> pConnections.stream().noneMatch(y -> x.edge().connected(y.edge())));
                if (connections.isEmpty()) break;
                nextNode.setFirst((Object)pNode);
            }
            currentNode = (Node)nextNode.getFirst();
            currentNode.setTransferPoint(true);
        }
        currentNode.setTransferPoint(true);
        route.add(currentNode);
        return route;
    }

    public ImmutableMap<UUID, TrainSchedule> createTrainSchedules() {
        return ImmutableMap.copyOf(TrainUtils.getTrains(true).stream().filter(x -> TrainListener.hasTrainData(x.id) && TrainUtils.isTrainUsable(x) && !this.globalSettings().isTrainBlacklisted((Train)x) && !this.globalSettings().isTrainExcludedByUser((Train)x, this.userSettings)).map(x -> new TrainSchedule(TrainListener.getTrainData(x.id).map(TrainData::getSessionId).orElse(new UUID(0L, 0L)), (Train)x)).collect(Collectors.toMap(x -> x.getTrain().id, x -> x)));
    }

    public List<Route> searchTrainsForRoute(List<Node> nodes) {
        ImmutableMap<UUID, TrainSchedule> schedules = this.createTrainSchedules();
        StringBuilder sb = new StringBuilder("Transfer points: ");
        ConcurrentLinkedQueue<Node> transferNodes = new ConcurrentLinkedQueue<Node>(nodes.stream().filter(x -> x.isTransferPoint()).peek(x -> {
            if (CreateRailwaysNavigator.isDebug()) {
                sb.append(x.getStationTag().getTagName().get() + " > ");
            }
        }).toList());
        if (CreateRailwaysNavigator.isDebug()) {
            CreateRailwaysNavigator.LOGGER.info(sb.toString());
        }
        if (transferNodes.size() <= 1) {
            return List.of();
        }
        Node start = (Node)transferNodes.poll();
        Node end = (Node)transferNodes.poll();
        HashSet<UUID> excludedTrainIds = new HashSet<UUID>();
        List<Train> departingTrains = TrainUtils.getDepartingTrainsAt(start.getStationTag()).stream().filter(train -> TrainListener.hasTrainData(train.id) && TrainUtils.isTrainUsable(train) && !excludedTrainIds.contains(train.id) && !this.globalSettings().isTrainBlacklisted((Train)train) && schedules.containsKey((Object)train.id) && ((TrainSchedule)schedules.get((Object)train.id)).stopsAt(start.getStationTag()) && ((TrainSchedule)schedules.get((Object)train.id)).stopsAt(end.getStationTag())).toList();
        if (CreateRailwaysNavigator.isDebug()) {
            CreateRailwaysNavigator.LOGGER.info(String.format("Found %s trains at station %s! Stations are: %s, %s", departingTrains.size(), start.getStationTag(), start.getStationTag(), end.getStationTag()));
        }
        ArrayList<Route> routes = new ArrayList<Route>();
        for (Train train2 : departingTrains) {
            RoutePart tempPart;
            TrainData trainData = TrainListener.getTrainData(train2.id).get();
            int simulationTime = this.userSettings.navigationDepartureInTicks.getValue();
            ConcurrentLinkedQueue<Node> tempTransferNodes = new ConcurrentLinkedQueue<Node>(transferNodes);
            Node tempEnd = end;
            RoutePart part = RoutePart.get(((TrainSchedule)schedules.get((Object)train2.id)).getSessionId(), ((TrainSchedule)schedules.get((Object)train2.id)).simulate(simulationTime), start.getStationTag(), end.getStationTag(), this.userSettings);
            if (!RoutePart.validate(part, trainData)) {
                if (!CreateRailwaysNavigator.isDebug()) continue;
                CreateRailwaysNavigator.LOGGER.info(String.format("Cannot use train %s at station %s: %s", train2.id, start.getStationTag(), part));
                continue;
            }
            while (!tempTransferNodes.isEmpty() && RoutePart.validate(tempPart = RoutePart.get(((TrainSchedule)schedules.get((Object)train2.id)).getSessionId(), ((TrainSchedule)schedules.get((Object)train2.id)).simulate(simulationTime), start.getStationTag(), ((Node)tempTransferNodes.peek()).getStationTag(), this.userSettings), trainData)) {
                tempEnd = (Node)tempTransferNodes.poll();
                part = tempPart;
            }
            if (((Boolean)ModCommonConfig.EXCLUDE_TRAINS.get()).booleanValue()) {
                excludedTrainIds.add(train2.id);
            }
            ArrayList<RoutePart> parts = new ArrayList<RoutePart>();
            parts.add(part);
            if (!tempTransferNodes.isEmpty()) {
                List<RoutePart> res;
                HashSet<UUID> exclTrns = new HashSet<UUID>(excludedTrainIds);
                if (((Boolean)ModCommonConfig.EXCLUDE_TRAINS.get()).booleanValue()) {
                    exclTrns.add(part.getTrainId());
                }
                if ((res = this.searchForTrainsInternal(tempEnd, schedules, new ConcurrentLinkedQueue<Node>(tempTransferNodes), exclTrns, part)) == null) continue;
                parts.addAll(res);
            }
            routes.add(new Route(parts, false));
        }
        return routes;
    }

    public List<RoutePart> searchForTrainsInternal(Node start, ImmutableMap<UUID, TrainSchedule> schedules, Queue<Node> transferNodes, Set<UUID> excludedTrainIds, RoutePart previousPart) {
        Node end = transferNodes.poll();
        List<Train> departingTrains = TrainUtils.getDepartingTrainsAt(start.getStationTag()).stream().filter(train -> TrainListener.hasTrainData(train.id) && TrainUtils.isTrainUsable(train) && !excludedTrainIds.contains(train.id) && !this.globalSettings().isTrainBlacklisted((Train)train) && schedules.containsKey((Object)train.id) && ((TrainSchedule)schedules.get((Object)train.id)).stopsAt(start.getStationTag()) && ((TrainSchedule)schedules.get((Object)train.id)).stopsAt(end.getStationTag())).toList();
        RoutePart bestPart = null;
        Node bestPartEnd = null;
        ConcurrentLinkedQueue<Node> bestPartRemainingTransfers = null;
        for (Train train2 : departingTrains) {
            RoutePart tempPart;
            TrainData trainData = TrainListener.getTrainData(train2.id).get();
            long simulationTime = previousPart.timeUntilEnd() - 1L + (long)this.userSettings.navigationTransferTime.getValue().intValue();
            ConcurrentLinkedQueue<Node> tempTransferNodes = new ConcurrentLinkedQueue<Node>(transferNodes);
            Node tempEnd = end;
            RoutePart part = RoutePart.get(((TrainSchedule)schedules.get((Object)train2.id)).getSessionId(), ((TrainSchedule)schedules.get((Object)train2.id)).simulate(simulationTime), start.getStationTag(), tempEnd.getStationTag(), this.userSettings);
            if (!RoutePart.validate(part, trainData)) continue;
            while (!tempTransferNodes.isEmpty() && RoutePart.validate(tempPart = RoutePart.get(((TrainSchedule)schedules.get((Object)train2.id)).getSessionId(), ((TrainSchedule)schedules.get((Object)train2.id)).simulate(simulationTime), start.getStationTag(), ((Node)tempTransferNodes.peek()).getStationTag(), this.userSettings), trainData)) {
                part = tempPart;
                tempEnd = (Node)tempTransferNodes.poll();
            }
            if (bestPart != null && part.compareTo(bestPart) > 0) continue;
            bestPart = part;
            bestPartEnd = tempEnd;
            bestPartRemainingTransfers = tempTransferNodes;
        }
        if (bestPart == null || bestPart.isEmpty()) {
            return null;
        }
        if (((Boolean)ModCommonConfig.EXCLUDE_TRAINS.get()).booleanValue()) {
            excludedTrainIds.add(bestPart.getTrainId());
        }
        ArrayList<RoutePart> parts = new ArrayList<RoutePart>();
        parts.add(bestPart);
        if (bestPartRemainingTransfers != null && !bestPartRemainingTransfers.isEmpty()) {
            List<RoutePart> res = this.searchForTrainsInternal(bestPartEnd, schedules, (Queue<Node>)bestPartRemainingTransfers, excludedTrainIds, bestPart);
            if (res == null) {
                return null;
            }
            parts.addAll(res);
        }
        return parts;
    }

    public static List<Route> searchRoutes(StationTag start, StationTag destination, UUID playerId, boolean avoidTransfers) {
        long startTime = System.currentTimeMillis();
        UserSettings userSettings = UserSettings.getSettingsFor(playerId, true);
        NavigatableGraph graph = new NavigatableGraph(userSettings);
        List<Node> nodes = graph.searchRoute(start, destination, avoidTransfers);
        List<Route> routes = graph.searchTrainsForRoute(nodes);
        int minNumber = routes.stream().mapToInt(x -> x.getTransferCount()).min().orElse(0);
        routes = routes.stream().filter(x -> x.getTransferCount() == minNumber).toList();
        if (((Boolean)ModCommonConfig.ADVANCED_LOGGING.get()).booleanValue()) {
            CreateRailwaysNavigator.LOGGER.info(String.format("%s route(s) calculated. Took %sms.", routes.size(), System.currentTimeMillis() - startTime));
        }
        return routes.stream().sorted((a, b) -> Long.compare(a.getStart().getScheduledDepartureTime(), b.getStart().getScheduledDepartureTime())).toList();
    }
}

