/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.train;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.schedule.Schedule;
import com.simibubi.create.content.trains.schedule.ScheduleEntry;
import com.simibubi.create.content.trains.schedule.destination.ChangeTitleInstruction;
import com.simibubi.create.content.trains.schedule.destination.DestinationInstruction;
import com.simibubi.create.content.trains.schedule.destination.ScheduleInstruction;
import com.simibubi.create.content.trains.station.GlobalStation;
import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.config.ModCommonConfig;
import de.mrjulsen.crn.data.TrainInfo;
import de.mrjulsen.crn.data.schedule.condition.DynamicDelayCondition;
import de.mrjulsen.crn.data.schedule.instruction.IPredictableInstruction;
import de.mrjulsen.crn.data.train.ScheduleSection;
import de.mrjulsen.crn.data.train.TrainPrediction;
import de.mrjulsen.crn.data.train.TrainStatus;
import de.mrjulsen.crn.data.train.TrainUtils;
import de.mrjulsen.crn.event.CRNEventsManager;
import de.mrjulsen.crn.event.events.TotalDurationTimeChangedEvent;
import de.mrjulsen.crn.mixin.ScheduleRuntimeAccessor;
import de.mrjulsen.crn.util.IListenable;
import de.mrjulsen.crn.util.LockedList;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.config.ECachingPriority;
import de.mrjulsen.mcdragonlib.data.Cache;
import de.mrjulsen.mcdragonlib.util.MathUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class TrainData
implements IListenable<TrainData> {
    private static final transient int VERSION = 1;
    public static final transient String EVENT_TOTAL_DURATION_CHANGED = "total_duration_changed";
    public static final transient String EVENT_SECTION_CHANGED = "section_changed";
    public static final transient String EVENT_DESTINATION_CHANGED = "destination_changed";
    public static final transient String EVENT_STATION_REACHED = "station_reached";
    private static final transient String NBT_VERSION = "Version";
    private static final transient String NBT_ID = "SessionId";
    private static final transient String NBT_TRAIN_ID = "TrainId";
    private static final transient String NBT_PREDICTIONS = "Predictions";
    private static final transient String NBT_CURRENT_SCHEDULE_INDEX = "CurrentScheduleIndex";
    private static final transient String NBT_LINE_ID = "LineId";
    private static final transient String NBT_LAST_DELAY_OFFSET = "LastDelay";
    private static final transient String NBT_CANCELLED = "Cancelled";
    private static final transient int INVALID = -1;
    private final transient Map<String, IdentityHashMap<Object, Consumer<TrainData>>> listeners = new HashMap<String, IdentityHashMap<Object, Consumer<TrainData>>>();
    private final transient Train train;
    private UUID sessionId;
    private final Map<Integer, TrainPrediction> predictionsByIndex = new ConcurrentHashMap<Integer, TrainPrediction>();
    private final transient List<TrainPrediction> predictionsChronologically = new LockedList<TrainPrediction>();
    private final transient Map<Integer, ScheduleSection> sectionsByIndex = new ConcurrentHashMap<Integer, ScheduleSection>();
    private transient int currentTravelSectionIndex = -1;
    private transient int lastScheduleIndex = -1;
    private String lineId;
    private transient int totalDuration = -1;
    public transient int transitTime = 0;
    public transient int waitingAtStationTime = 0;
    private transient boolean wasAtStation = false;
    private transient int wasAtStationIndex = -1;
    private transient boolean wasWaitingForSignal = false;
    public transient UUID waitingForSignalId;
    public final transient Set<Train> occupyingTrains = new HashSet<Train>();
    public transient int waitingForSignalTicks;
    public transient boolean isManualControlled;
    private long lastSectionDelayOffset;
    private boolean cancelled = false;
    private final transient Map<UUID, Integer> delaysBySignal = new HashMap<UUID, Integer>();
    private final Set<ResourceLocation> currentStatusInfos = new HashSet<ResourceLocation>();
    private int refreshTimingsCounter = 0;
    private transient boolean hardResetPredictions = false;
    private transient boolean initializationCompleted = false;
    private transient boolean preInitialization = true;
    private boolean sectionChanged;
    private boolean destinationChanged;
    private boolean scheduleIndexChanged;
    private final transient Cache<ScheduleSection> defaultSection = new Cache(() -> ScheduleSection.def(this), ECachingPriority.LOW);
    private final transient Cache<Boolean> isDynamic = new Cache(() -> this.getTrain() != null && this.getTrain().runtime != null && this.getTrain().runtime.getSchedule() != null && this.getTrain().runtime.getSchedule().entries.stream().anyMatch(x -> x.conditions.stream().flatMap(y -> y.stream()).anyMatch(y -> {
        DynamicDelayCondition c;
        return y instanceof DynamicDelayCondition && (c = (DynamicDelayCondition)y).minWaitTicks() < c.totalWaitTicks();
    })));
    private final transient Cache<Boolean> isDelayedCache = new Cache(() -> {
        for (TrainPrediction pred : this.predictionsByIndex.values()) {
            if (!pred.isAnyDelayed()) continue;
            return true;
        }
        return false;
    });
    private final transient Cache<Long> highestDeviationCache = new Cache(() -> {
        long max = 0L;
        for (TrainPrediction pred : this.predictionsByIndex.values()) {
            max = Math.max(Math.max(pred.getArrivalTimeDeviation(), pred.getDepartureTimeDeviation()), max);
        }
        return max;
    });
    private final transient Cache<ScheduleSection> currentSectionCache = new Cache(() -> this.currentTravelSectionIndex < 0 || !this.hasCustomScheduleSections() || !this.sectionsByIndex.containsKey(this.currentTravelSectionIndex) ? (ScheduleSection)this.defaultSection.get() : this.sectionsByIndex.get(this.currentTravelSectionIndex));
    private final Cache<List<ScheduleSection>> sectionsCache = new Cache(() -> this.sectionsByIndex.isEmpty() ? List.of((ScheduleSection)this.defaultSection.get()) : this.sectionsByIndex.values().stream().sorted((a, b) -> Integer.compare(a.getScheduleIndex(), b.getScheduleIndex())).toList());
    private final Cache<Boolean> isInitializedCache = new Cache(() -> {
        for (TrainPrediction pred : this.getPredictions()) {
            if (pred.isInitialized()) continue;
            return false;
        }
        return true;
    });
    public int ticksToNextStop = 0;
    public int waitingAtStationIndex = -1;
    private final Queue<Runnable> deferredTickQueue = new ConcurrentLinkedQueue<Runnable>();

    private TrainData(Train train, UUID sessionId) {
        this.train = train;
        this.sessionId = sessionId;
        this.totalDuration = -1;
        this.transitTime = ((ScheduleRuntimeAccessor)train.runtime).crn$getTicksInPreviousTransit();
        this.createEvent(EVENT_TOTAL_DURATION_CHANGED);
        this.createEvent(EVENT_DESTINATION_CHANGED);
        this.createEvent(EVENT_SECTION_CHANGED);
        this.createEvent(EVENT_STATION_REACHED);
    }

    public static Optional<TrainData> of(UUID trainId) {
        Optional<Train> train = TrainUtils.getTrain(trainId);
        if (train.isPresent()) {
            return Optional.of(new TrainData(train.get(), UUID.randomUUID()));
        }
        return Optional.empty();
    }

    public static TrainData of(Train train) {
        return new TrainData(train, UUID.randomUUID());
    }

    public UUID getSessionId() {
        return this.sessionId;
    }

    public UUID getTrainId() {
        return this.getTrain().id;
    }

    public Train getTrain() {
        return this.train;
    }

    public TrainInfo getTrainInfo(int scheduleIndex) {
        return new TrainInfo(this.getSectionForIndex(scheduleIndex).getTrainLine().orElse(null), this.getSectionForIndex(scheduleIndex).getTrainCategory().orElse(null));
    }

    public boolean isDynamic() {
        return (Boolean)this.isDynamic.get();
    }

    public boolean isAtStation() {
        return this.train.navigation.destination == null;
    }

    public long waitingAtStationTicks() {
        return this.waitingAtStationTime;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public int getTotalDuration() {
        return this.totalDuration;
    }

    @Deprecated(forRemoval=true)
    public int getTransitTicks() {
        return this.transitTime;
    }

    @Deprecated(forRemoval=true)
    public int getTransitTimeOf(int scheduleIndex) {
        return this.predictionsByIndex.containsKey(scheduleIndex) ? this.predictionsByIndex.get(scheduleIndex).transitTime().value() : -1;
    }

    public Optional<TrainPrediction> getPredictionByIndex(int scheduleIndex) {
        return Optional.ofNullable(this.predictionsByIndex.get(scheduleIndex));
    }

    public ScheduleSection getSectionByIndex(int scheduleIndex) {
        return this.sectionsByIndex.isEmpty() ? (ScheduleSection)this.defaultSection.get() : this.sectionsByIndex.get(scheduleIndex);
    }

    public void addScheduleSection(ScheduleSection section) {
        this.sectionsByIndex.put(section.getScheduleIndex(), section);
        this.sectionsCache.clear();
        this.currentSectionCache.clear();
    }

    public String getCurrentTitle() {
        return this.getPredictionByIndex(this.getCurrentScheduleIndex()).map(TrainPrediction::getTitle).orElse("");
    }

    public String getTrainName() {
        return this.train.name.getString();
    }

    public String getTrainDisplayName() {
        return this.getCurrentSection() == null || this.getCurrentSection().getTrainLine().map(x -> x.getLineName().isEmpty()).orElse(true) != false ? this.getTrainName() : this.getCurrentSection().getTrainLine().get().getLineName();
    }

    public int getCurrentScheduleIndex() {
        return this.getTrain().runtime.currentEntry;
    }

    public boolean hasCustomScheduleSections() {
        return !this.sectionsByIndex.isEmpty();
    }

    public boolean isSingleSection() {
        return this.sectionsByIndex.size() <= 1;
    }

    public List<ScheduleSection> getSections() {
        return (List)this.sectionsCache.get();
    }

    public ScheduleSection getSectionForIndex(int anyIndex) {
        if (this.isSingleSection()) {
            return this.getSections().get(0);
        }
        ScheduleSection selectedSection = this.getSections().get(this.getSections().size() - 1);
        for (ScheduleSection section : this.getSections()) {
            if (section.getScheduleIndex() > anyIndex) break;
            selectedSection = section;
        }
        return selectedSection;
    }

    public synchronized List<TrainPrediction> getPredictions() {
        return ImmutableList.copyOf(this.predictionsByIndex.values());
    }

    public synchronized boolean hasPredictions() {
        return !this.predictionsByIndex.isEmpty();
    }

    public synchronized Map<Integer, TrainPrediction> getPredictionsMap() {
        return ImmutableMap.copyOf(this.predictionsByIndex);
    }

    public synchronized List<TrainPrediction> getPredictionsChronologically() {
        return ImmutableList.copyOf(this.predictionsChronologically);
    }

    public synchronized Optional<TrainPrediction> getNextStopPrediction() {
        return this.predictionsChronologically.isEmpty() ? Optional.empty() : Optional.ofNullable(this.predictionsChronologically.get(0));
    }

    public synchronized boolean isDelayed() {
        return (Boolean)this.isDelayedCache.get();
    }

    public boolean isCurrentSectionDelayed() {
        return this.isDelayed() && this.getHighestDeviation() - this.lastSectionDelayOffset > (long)((Integer)ModCommonConfig.SCHEDULE_DEVIATION_THRESHOLD.get()).intValue();
    }

    public long getHighestDeviation() {
        return (Long)this.highestDeviationCache.get();
    }

    public long getDeviationDelayOffset() {
        return this.lastSectionDelayOffset;
    }

    public ScheduleSection getCurrentSection() {
        return (ScheduleSection)this.currentSectionCache.get();
    }

    public Map<UUID, Integer> getWaitingForSignalsTime() {
        return ImmutableMap.copyOf(this.delaysBySignal);
    }

    public Set<ResourceLocation> getStatus() {
        return this.currentStatusInfos;
    }

    public int debug_statusInfoCount() {
        return this.currentStatusInfos.size();
    }

    public void softResetPredictions() {
        for (TrainPrediction pred : this.predictionsByIndex.values()) {
            pred.queueReset();
        }
        this.lastSectionDelayOffset = 0L;
        this.refreshTimingsCounter = 0;
        this.wasAtStationIndex = -1;
        this.resetStatus(true);
        this.isDynamic.clear();
        if (CreateRailwaysNavigator.isDebug() || ((Boolean)ModCommonConfig.ADVANCED_LOGGING.get()).booleanValue()) {
            CreateRailwaysNavigator.LOGGER.info(this.getTrainName() + " has reset their scheduled times.");
        }
    }

    public void hardResetPredictions() {
        this.preInitialization = true;
        this.hardResetPredictions = true;
    }

    private void resetStatus(boolean keepPreviousDelays) {
        this.currentStatusInfos.clear();
        if (keepPreviousDelays && this.isDelayed()) {
            this.currentStatusInfos.add(TrainStatus.DELAY_FROM_PREVIOUS_JOURNEY.getLocation());
        }
    }

    public void applyStatus() {
        if (this.isCancelled()) {
            this.currentStatusInfos.clear();
            this.currentStatusInfos.add(TrainStatus.CANCELLED.getLocation());
            return;
        }
        for (Map.Entry x : TrainStatus.Registry.getRegisteredStatus().entrySet()) {
            if (!((TrainStatus)x.getValue()).isTriggerd(this)) continue;
            this.currentStatusInfos.add((ResourceLocation)x.getKey());
        }
        boolean unknownDelayReason = this.isCurrentSectionDelayed();
        if (unknownDelayReason) {
            for (ResourceLocation loc : this.currentStatusInfos) {
                if (((TrainStatus)TrainStatus.Registry.getRegisteredStatus().get((Object)loc)).getImportance() != TrainStatus.TrainStatusType.DELAY || loc.equals((Object)TrainStatus.DEFAULT_DELAY.getLocation())) continue;
                unknownDelayReason = false;
                break;
            }
        }
        if (unknownDelayReason) {
            this.currentStatusInfos.add(TrainStatus.DEFAULT_DELAY.getLocation());
        } else {
            this.currentStatusInfos.remove(TrainStatus.DEFAULT_DELAY.getLocation());
        }
    }

    public boolean hasSectionChanged() {
        return this.sectionChanged;
    }

    public boolean isInitialized() {
        return (Boolean)this.isInitializedCache.get();
    }

    public boolean isPreInitializationPhase() {
        return this.preInitialization;
    }

    public int debug_initializedStationsCount() {
        return (int)this.getPredictions().stream().mapToInt(x -> x.transitTime().value()).filter(x -> x > 0).count();
    }

    public synchronized void shiftTime(long l) {
        if (!this.isPreInitializationPhase()) {
            this.predictionsByIndex.values().forEach(x -> x.shiftTime(l));
        }
    }

    public void changeCurrentSection(int sectionEntryIndex) {
        this.currentTravelSectionIndex = this.sectionsByIndex.containsKey(sectionEntryIndex) ? sectionEntryIndex : -1;
        this.sectionChanged = true;
        this.lastSectionDelayOffset = Math.max(0L, this.getHighestDeviation());
        ++this.refreshTimingsCounter;
        this.currentSectionCache.clear();
    }

    private int getTransitTimeAtStation(int index) {
        if (this.predictionsByIndex.containsKey(index)) {
            return this.predictionsByIndex.get(index).transitTime().value();
        }
        List<Integer> transitTimesFromCreate = ((ScheduleRuntimeAccessor)this.train.runtime).crn$getTransitTicks();
        int transitTime = transitTimesFromCreate.size() > index ? transitTimesFromCreate.get(index) : -1;
        return transitTime;
    }

    public int predictTimeToNextStop() {
        GlobalStation destination = this.train.navigation.destination;
        int accumulatedTime = 0;
        if (destination != null) {
            float predictedTime;
            List<Integer> transitTimesFromCreate = ((ScheduleRuntimeAccessor)this.train.runtime).crn$getTransitTicks();
            double speed = Math.min(this.train.throttle * (double)this.train.maxSpeed(), (double)((this.train.maxSpeed() + this.train.maxTurnSpeed()) / 2.0f));
            int timeRemaining = (int)(this.train.navigation.distanceToDestination / speed) * 2;
            if (transitTimesFromCreate.size() > this.train.runtime.currentEntry && this.train.navigation.distanceStartedAt != 0.0 && (predictedTime = (float)transitTimesFromCreate.get(this.train.runtime.currentEntry).intValue()) > 0.0f) {
                predictedTime = (float)((double)predictedTime * MathUtils.clamp((double)(this.train.navigation.distanceToDestination / this.train.navigation.distanceStartedAt), (double)0.0, (double)1.0));
                timeRemaining = (timeRemaining + (int)predictedTime) / 2;
            }
            accumulatedTime += timeRemaining;
        }
        return accumulatedTime;
    }

    private void clearAll() {
        this.preInitialization = true;
        this.predictionsByIndex.clear();
        this.sectionsByIndex.clear();
        this.defaultSection.clear();
        this.predictionsChronologically.clear();
        this.currentStatusInfos.clear();
        this.currentSectionCache.clear();
        this.sectionsCache.clear();
        this.lastScheduleIndex = -1;
        this.totalDuration = -1;
        this.wasAtStationIndex = -1;
        this.resetCaches();
    }

    public synchronized void refreshPre() {
        if (this.hardResetPredictions) {
            this.hardResetPredictions = false;
            this.clearAll();
        }
        if (this.train.runtime.paused) {
            return;
        }
        boolean bl = this.scheduleIndexChanged = this.lastScheduleIndex != this.getCurrentScheduleIndex();
        if (this.scheduleIndexChanged && this.lastScheduleIndex >= 0 && this.predictionsByIndex.containsKey(this.lastScheduleIndex)) {
            this.predictionsByIndex.get(this.lastScheduleIndex).nextCycle();
        }
        if (!this.hasCustomScheduleSections() && this.lastScheduleIndex > this.getCurrentScheduleIndex()) {
            this.changeCurrentSection(this.currentTravelSectionIndex);
        }
        this.lastScheduleIndex = this.getCurrentScheduleIndex();
        this.calcPredictions();
    }

    private void calcPredictions() {
        long now;
        this.predictionsChronologically.clear();
        Schedule schedule = this.train.runtime.getSchedule();
        int entryCount = this.train.runtime.getSchedule().entries.size();
        AtomicReference<String> currentTitle = new AtomicReference<String>("");
        for (int i = 0; i < entryCount; ++i) {
            int cyclicIndex = (i + this.getCurrentScheduleIndex()) % entryCount;
            ScheduleEntry entry = (ScheduleEntry)schedule.entries.get(cyclicIndex);
            ScheduleInstruction scheduleInstruction = entry.instruction;
            if (!(scheduleInstruction instanceof ChangeTitleInstruction)) continue;
            ChangeTitleInstruction instruction = (ChangeTitleInstruction)scheduleInstruction;
            currentTitle.set(instruction.getScheduleTitle());
        }
        HashSet<Integer> validPredictionEntries = new HashSet<Integer>();
        boolean hasCycled = false;
        long time = now = DragonLib.getCurrentWorldTime() - this.waitingAtStationTicks();
        for (int i = 0; i < entryCount; ++i) {
            int cyclicIndex = (i + this.getCurrentScheduleIndex()) % entryCount;
            ScheduleEntry entry = (ScheduleEntry)schedule.entries.get(cyclicIndex);
            ScheduleInstruction scheduleInstruction = entry.instruction;
            if (scheduleInstruction instanceof IPredictableInstruction) {
                IPredictableInstruction instruction = (IPredictableInstruction)scheduleInstruction;
                instruction.predict(this, this.train.runtime, cyclicIndex, this.train);
                continue;
            }
            scheduleInstruction = entry.instruction;
            if (scheduleInstruction instanceof ChangeTitleInstruction) {
                ChangeTitleInstruction instruction = (ChangeTitleInstruction)scheduleInstruction;
                currentTitle.set(instruction.getScheduleTitle());
                continue;
            }
            if (!(entry.instruction instanceof DestinationInstruction)) continue;
            validPredictionEntries.add(cyclicIndex);
            DestinationInstruction destination = (DestinationInstruction)entry.instruction;
            AtomicReference<String> name = new AtomicReference<String>(destination.getFilter());
            if (i <= 0) {
                this.ticksToNextStop = this.predictTimeToNextStop();
                time += (long)this.ticksToNextStop;
                GlobalStation destStation = this.train.navigation.destination != null ? this.train.navigation.destination : this.train.getCurrentStation();
                name.set(destStation != null ? destStation.name : name.get());
            } else {
                if (hasCycled || cyclicIndex == 0 && !this.train.runtime.getSchedule().cyclic) {
                    hasCycled = true;
                    continue;
                }
                time += (long)this.getTransitTimeAtStation(cyclicIndex);
            }
            TrainPrediction pred = this.predictionsByIndex.computeIfAbsent(cyclicIndex, idx -> new TrainPrediction(this, (int)idx, destination.getFilter(), (String)name.get(), (String)currentTitle.get()));
            if (!this.isPreInitializationPhase()) {
                pred.preInit();
            }
            this.predictionsChronologically.add(pred);
            pred.updateRealTime(destination.getFilter(), name.get(), now, time, currentTitle.get());
            time = pred.realTime().departureTime();
        }
        this.predictionsByIndex.keySet().retainAll(validPredictionEntries);
    }

    public SimulationResult simulate(int entryIndex, long duration) {
        long now;
        long time;
        Schedule schedule = this.train.runtime.getSchedule();
        int entryCount = this.train.runtime.getSchedule().entries.size();
        long lastTime = time = (now = this.predictionsByIndex.get(entryIndex).scheduled().departureTime());
        SimulationResult result = new SimulationResult(entryIndex, 0, now, now);
        int iteration = 0;
        while (duration - (now - DragonLib.getCurrentWorldTime()) > 0L) {
            long arrival = 0L;
            long departure = 0L;
            for (int i = 0; i < entryCount; ++i) {
                int cyclicIndex = (i + (entryIndex + 1)) % entryCount;
                ScheduleEntry entry = (ScheduleEntry)schedule.entries.get(cyclicIndex);
                if (!(entry.instruction instanceof DestinationInstruction)) continue;
                if (cyclicIndex == 0 && !this.train.runtime.getSchedule().cyclic) {
                    return result;
                }
                long newArrivalTime = time += (long)this.getTransitTimeAtStation(cyclicIndex);
                time = TrainPrediction.estimateDepartures(this.getTrain(), cyclicIndex, time).defaultDepartureTime();
                if (cyclicIndex != entryIndex) continue;
                arrival = newArrivalTime;
                departure = time;
            }
            result = new SimulationResult(entryIndex, ++iteration, arrival, departure);
            duration -= time - lastTime;
            lastTime = time;
        }
        return result;
    }

    public synchronized void refreshPost() {
        boolean isNowCancelled;
        boolean bl = isNowCancelled = !TrainUtils.isTrainValid(this.train) || !this.isInitialized() || this.train.runtime.paused;
        if (this.cancelled && !isNowCancelled) {
            this.initializationCompleted = false;
            this.sessionId = UUID.randomUUID();
            this.softResetPredictions();
        }
        this.cancelled = isNowCancelled;
        this.applyStatus();
        if (this.destinationChanged) {
            this.destinationChanged = false;
            this.notifyListeners(EVENT_DESTINATION_CHANGED, this);
        }
        this.resetCaches();
        this.scheduleIndexChanged = false;
        this.waitingAtStationIndex = this.isAtStation() ? this.getCurrentScheduleIndex() : -1;
    }

    private void resetCaches() {
        this.isDelayedCache.clear();
        this.highestDeviationCache.clear();
        this.isInitializedCache.clear();
    }

    public void tick() {
        boolean isWaitingForSignal;
        boolean stationIndexChanged;
        if (this.train.runtime.paused) {
            return;
        }
        while (!this.deferredTickQueue.isEmpty()) {
            this.deferredTickQueue.poll().run();
        }
        boolean isAtStation = this.isAtStation();
        int isAtStationIndex = this.train.runtime.currentEntry;
        boolean stationChanged = this.wasAtStation != isAtStation;
        boolean bl = stationIndexChanged = this.wasAtStationIndex != isAtStationIndex;
        if (stationChanged) {
            if (isAtStation) {
                this.onReachDestination();
            } else {
                this.onLeaveDestination();
            }
            this.wasAtStation = isAtStation;
        } else if (this.wasAtStationIndex > -1 && isAtStation && stationIndexChanged && this.predictionsByIndex.containsKey(this.getCurrentScheduleIndex())) {
            this.deferredTickQueue.add(() -> {
                if (!this.isAtStation() || !this.predictionsByIndex.containsKey(this.getCurrentScheduleIndex())) {
                    return;
                }
                this.transitTime = 0;
                this.waitingAtStationTime = 0;
                this.waitingForSignalTicks = 0;
                this.waitingForSignalId = null;
                this.delaysBySignal.clear();
                this.onReachDestination();
            });
        }
        this.wasAtStationIndex = isAtStationIndex;
        if (isAtStation) {
            ++this.waitingAtStationTime;
        } else {
            ++this.transitTime;
        }
        boolean bl2 = isWaitingForSignal = this.train.navigation.waitingForSignal != null;
        if (this.wasWaitingForSignal != isWaitingForSignal) {
            if (isWaitingForSignal) {
                this.waitingForSignalId = (UUID)this.train.navigation.waitingForSignal.getFirst();
                this.occupyingTrains.clear();
                this.occupyingTrains.addAll(TrainUtils.isSignalOccupied(this.waitingForSignalId, Set.of(this.train.id)));
            } else {
                this.delaysBySignal.put(this.waitingForSignalId, this.waitingForSignalTicks);
                this.waitingForSignalTicks = 0;
                this.occupyingTrains.clear();
            }
            this.wasWaitingForSignal = isWaitingForSignal;
        }
        if (isWaitingForSignal) {
            ++this.waitingForSignalTicks;
        }
    }

    public void updateTotalDuration() {
        int newDuration = this.getPredictions().stream().mapToInt(x -> x.transitTime().value() + (int)x.scheduled().stayDuration()).sum();
        int oldTotalDuration = this.totalDuration;
        if (CRNEventsManager.isRegistered(TotalDurationTimeChangedEvent.class) && this.totalDuration > 0 && this.totalDuration != newDuration) {
            CRNEventsManager.getEvent(TotalDurationTimeChangedEvent.class).run(this.train, this.totalDuration, newDuration);
        }
        this.totalDuration = newDuration;
        if (oldTotalDuration != -1) {
            this.notifyListeners(EVENT_TOTAL_DURATION_CHANGED, this);
        }
        this.softResetPredictions();
    }

    public void onReachDestination() {
        if (!this.isPreInitializationPhase()) {
            this.getPredictionByIndex(this.getCurrentScheduleIndex()).ifPresent(x -> {
                x.transitTime().add(this.transitTime, false);
                x.onReachStation();
            });
        }
        this.transitTime = 0;
        this.waitingAtStationTime = 0;
        this.waitingForSignalTicks = 0;
        this.waitingForSignalId = null;
        this.delaysBySignal.clear();
        this.preInitialization = false;
        if (!this.initializationCompleted && this.isInitialized()) {
            this.completeInitialization();
        }
        this.notifyListeners(EVENT_STATION_REACHED, this);
    }

    public void onLeaveDestination() {
        if (!this.isPreInitializationPhase()) {
            this.getPredictionByIndex(this.getCurrentScheduleIndex()).ifPresent(x -> x.updateAverageStayDuration(this.waitingAtStationTime));
        }
        if (this.sectionChanged) {
            this.sectionChanged = false;
            if (!this.isDynamic() || (Integer)ModCommonConfig.AUTO_RESET_TIMINGS.get() > 0 && this.refreshTimingsCounter >= (Integer)ModCommonConfig.AUTO_RESET_TIMINGS.get()) {
                this.softResetPredictions();
            } else {
                this.resetStatus(true);
            }
            this.notifyListeners(EVENT_SECTION_CHANGED, this);
        }
        this.transitTime = 0;
        this.waitingAtStationTime = 0;
        this.waitingForSignalTicks = 0;
        this.waitingForSignalId = null;
        this.delaysBySignal.clear();
    }

    public void completeInitialization() {
        this.updateTotalDuration();
        this.isDynamic.clear();
        this.initializationCompleted = true;
    }

    @Override
    public Map<String, IdentityHashMap<Object, Consumer<TrainData>>> getListeners() {
        return this.listeners;
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.putInt(NBT_VERSION, 1);
        CompoundTag predictions = new CompoundTag();
        for (Map.Entry<Integer, TrainPrediction> entry : this.predictionsByIndex.entrySet()) {
            predictions.put(String.valueOf(entry.getKey()), (Tag)entry.getValue().toNbt());
        }
        nbt.putUUID(NBT_ID, this.getSessionId());
        nbt.putUUID(NBT_TRAIN_ID, this.getTrainId());
        nbt.put(NBT_PREDICTIONS, (Tag)predictions);
        nbt.putInt(NBT_CURRENT_SCHEDULE_INDEX, this.getCurrentScheduleIndex());
        nbt.putLong(NBT_LAST_DELAY_OFFSET, this.lastSectionDelayOffset);
        nbt.putBoolean(NBT_CANCELLED, this.cancelled);
        nbt.putString(NBT_LINE_ID, this.lineId == null ? "" : this.lineId);
        return nbt;
    }

    public static Optional<TrainData> fromNbt(CompoundTag nbt) {
        UUID trainId = nbt.getUUID(NBT_TRAIN_ID);
        UUID sessionId = nbt.getUUID(NBT_ID);
        Optional<Train> train = TrainUtils.getTrain(trainId);
        if (train.isPresent()) {
            TrainData data = new TrainData(train.get(), sessionId);
            data.deserializeNbt(nbt);
            return Optional.ofNullable(data);
        }
        CreateRailwaysNavigator.LOGGER.warn("Cannot load data for train with id " + String.valueOf(trainId) + ", because that train does not exist.");
        return Optional.empty();
    }

    protected void deserializeNbt(CompoundTag nbt) {
        int currentScheduleIndex;
        CompoundTag predictions = nbt.getCompound(NBT_PREDICTIONS);
        for (String key : predictions.getAllKeys()) {
            try {
                int idx = Integer.parseInt(key);
                this.predictionsByIndex.put(idx, TrainPrediction.fromNbt(this, predictions.getCompound(key)));
            }
            catch (Exception e) {
                CreateRailwaysNavigator.LOGGER.warn("Unable to load prediction with index '" + key + "': The value is not an integer.", (Throwable)e);
            }
        }
        this.lastScheduleIndex = currentScheduleIndex = nbt.getInt(NBT_CURRENT_SCHEDULE_INDEX);
        this.currentTravelSectionIndex = this.getSectionForIndex(currentScheduleIndex).getScheduleIndex();
        this.lineId = nbt.getString(NBT_LINE_ID);
        this.lastSectionDelayOffset = nbt.getLong(NBT_LAST_DELAY_OFFSET);
        this.cancelled = nbt.getBoolean(NBT_CANCELLED);
    }

    public record SimulationResult(int entryIndex, int cycles, long arrivalTime, long departureTime) {
    }
}

