/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.neoforge;

import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.config.ModCommonConfig;
import de.mrjulsen.crn.neoforge.CreateRailwaysNavigatorNeoForge;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.UsernameCache;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class CRNPlatformSpecificImpl {
    public static Path getConfigDirectory() {
        return FMLPaths.CONFIGDIR.get();
    }

    public static MinecraftServer getServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    public static void registerConfig() {
        if (Platform.getEnvironment() == Env.CLIENT) {
            CreateRailwaysNavigatorNeoForge.getModContainer().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ModClientConfig.SPEC, "createrailwaysnavigator-client.toml");
        }
        CreateRailwaysNavigatorNeoForge.getModContainer().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ModCommonConfig.SPEC, "createrailwaysnavigator-common.toml");
    }

    public static Optional<String> getLastKnownPlayerName(UUID uuid) {
        return Optional.ofNullable(UsernameCache.getLastKnownUsername((UUID)uuid));
    }

    public static Map<UUID, String> getAllKnownPlayers() {
        return UsernameCache.getMap();
    }

    public static GlobalStation getStationFromBlockEntity(BlockEntity be) {
        if (!(be instanceof StationBlockEntity)) {
            return null;
        }
        StationBlockEntity stationBe = (StationBlockEntity)be;
        return stationBe.getStation();
    }
}

