/*
 * Decompiled with CFR 0.152.
 */
package com.aesefficio.interiors.content.block.chair;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.actors.seat.SeatMovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import java.util.Map;
import java.util.UUID;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.Vec3;

public class BigSeatMovementBehaviour
extends SeatMovementBehaviour {
    public void visitNewPosition(MovementContext context, BlockPos pos) {
        boolean solid;
        AbstractContraptionEntity contraptionEntity = context.contraption.entity;
        if (contraptionEntity == null) {
            return;
        }
        int index = context.data.getInt("SeatIndex");
        if (index == -1) {
            return;
        }
        Map seatMapping = context.contraption.getSeatMapping();
        BlockState blockState = context.world.getBlockState(pos);
        boolean bl = solid = blockState.canOcclude() || blockState.getBlock() instanceof SlabBlock && blockState.getValue((Property)SlabBlock.TYPE) == SlabType.BOTTOM;
        if (!seatMapping.containsValue(index) || !solid) {
            return;
        }
        Entity toDismount = null;
        for (Map.Entry entry : seatMapping.entrySet()) {
            if ((Integer)entry.getValue() != index) continue;
            for (Entity entity : contraptionEntity.getPassengers()) {
                if (!((UUID)entry.getKey()).equals(entity.getUUID())) continue;
                toDismount = entity;
            }
        }
        if (toDismount == null) {
            return;
        }
        toDismount.stopRiding();
        Vec3 position = VecHelper.getCenterOf((Vec3i)pos).add(0.0, 1.0, 0.0);
        toDismount.teleportTo(position.x, position.y, position.z);
        toDismount.getPersistentData().remove("ContraptionDismountLocation");
    }
}

