/*
 * Decompiled with CFR 0.152.
 */
package com.aesefficio.interiors.content.block.chair;

import com.aesefficio.interiors.Utils;
import com.aesefficio.interiors.content.block.chair.DirectionalSeatBlock;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import net.createmod.catnip.lang.Lang;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class ChairBlock
extends DirectionalSeatBlock
implements ProperWaterloggedBlock {
    public static final EnumProperty<ArmrestConfiguration> ARMRESTS = EnumProperty.create((String)"armrests", ArmrestConfiguration.class);
    public static final BooleanProperty CROPPED_BACK = BooleanProperty.create((String)"cropped_back");
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    protected final DyeColor color;

    public ChairBlock(BlockBehaviour.Properties properties, DyeColor color) {
        super(properties, color);
        this.color = color;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue(ARMRESTS, (Comparable)((Object)ArmrestConfiguration.DEFAULT))).setValue((Property)CROPPED_BACK, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{ARMRESTS}).add(new Property[]{CROPPED_BACK}));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public abstract VoxelShape shape();

    public void updateEntityAfterFallOn(BlockGetter reader, Entity entity) {
        BlockPos pos = entity.blockPosition();
        if (entity instanceof Player || !(entity instanceof LivingEntity) || !ChairBlock.canBePickedUp((Entity)entity) || ChairBlock.isSeatOccupied((Level)entity.level(), (BlockPos)pos)) {
            if (entity.isSuppressingBounce()) {
                super.updateEntityAfterFallOn(reader, entity);
                return;
            }
            Vec3 vec3 = entity.getDeltaMovement();
            if (vec3.y < 0.0) {
                double d0 = entity instanceof LivingEntity ? 1.0 : 0.8;
                entity.setDeltaMovement(vec3.x, -vec3.y * 0.66 * d0, vec3.z);
            }
            return;
        }
        if (reader.getBlockState(pos).getBlock() != this) {
            return;
        }
        ChairBlock.sitDown((Level)entity.level(), (BlockPos)pos, (Entity)entity);
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Vec3 clickPos = pos.getCenter().subtract(context.getClickLocation());
        switch ((Direction)state.getValue((Property)FACING)) {
            case NORTH: {
                BlockState blockState;
                if (clickPos.x > 0.0) {
                    blockState = this.toggleLeft(state);
                    break;
                }
                blockState = this.toggleRight(state);
                break;
            }
            case SOUTH: {
                BlockState blockState;
                if (clickPos.x < 0.0) {
                    blockState = this.toggleLeft(state);
                    break;
                }
                blockState = this.toggleRight(state);
                break;
            }
            case WEST: {
                BlockState blockState;
                if (clickPos.z < 0.0) {
                    blockState = this.toggleLeft(state);
                    break;
                }
                blockState = this.toggleRight(state);
                break;
            }
            case EAST: {
                BlockState blockState;
                if (clickPos.z > 0.0) {
                    blockState = this.toggleLeft(state);
                    break;
                }
                blockState = this.toggleRight(state);
                break;
            }
            default: {
                BlockState blockState = state = state;
            }
        }
        if (!world.isClientSide) {
            world.setBlock(pos, state, 3);
        }
        return InteractionResult.SUCCESS;
    }

    private BlockState toggleBackCrop(BlockState state) {
        boolean currentValue = (Boolean)state.getValue((Property)CROPPED_BACK);
        return (BlockState)state.setValue((Property)CROPPED_BACK, (Comparable)Boolean.valueOf(!currentValue));
    }

    private BlockState toggleLeft(BlockState state) {
        return (BlockState)state.setValue(ARMRESTS, (Comparable)((Object)(switch (((ArmrestConfiguration)((Object)state.getValue(ARMRESTS))).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> ArmrestConfiguration.RIGHT;
            case 1 -> ArmrestConfiguration.LEFT;
            case 2 -> ArmrestConfiguration.NONE;
            case 3 -> ArmrestConfiguration.BOTH;
        })));
    }

    private BlockState toggleRight(BlockState state) {
        return (BlockState)state.setValue(ARMRESTS, (Comparable)((Object)(switch (((ArmrestConfiguration)((Object)state.getValue(ARMRESTS))).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> ArmrestConfiguration.LEFT;
            case 1 -> ArmrestConfiguration.RIGHT;
            case 2 -> ArmrestConfiguration.BOTH;
            case 3 -> ArmrestConfiguration.NONE;
        })));
    }

    @Override
    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        if (!world.isClientSide) {
            world.setBlock(pos, this.toggleBackCrop(state), 3);
        }
        return InteractionResult.SUCCESS;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.NORTH -> this.shape();
            case Direction.SOUTH -> Utils.rotateShape(Direction.NORTH, Direction.WEST, this.shape());
            case Direction.WEST -> Utils.rotateShape(Direction.NORTH, Direction.EAST, this.shape());
            default -> Utils.rotateShape(Direction.NORTH, Direction.SOUTH, this.shape());
        };
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getShape(state, level, pos, context);
    }

    public static enum ArmrestConfiguration implements StringRepresentable
    {
        BOTH,
        NONE,
        LEFT,
        RIGHT;

        public static final ArmrestConfiguration DEFAULT;

        public String getSerializedName() {
            return Lang.asId((String)this.name());
        }

        static {
            DEFAULT = BOTH;
        }
    }
}

