/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndecor.content.blocks.frontlight;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import dev.lopyluna.dndecor.content.blocks.frontlight.Frontlight;
import dev.lopyluna.dndecor.register.DnDecorShapes;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class FrontlightBlock
extends Block
implements IWrenchable {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final EnumProperty<Frontlight> ADDITIVE = EnumProperty.create((String)"additive", Frontlight.class);
    public static final BooleanProperty ROTATED = BooleanProperty.create((String)"rotated");

    public FrontlightBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue(ADDITIVE, (Comparable)((Object)Frontlight.TOP))).setValue((Property)ROTATED, (Comparable)Boolean.valueOf(false)));
    }

    public static int getLight(BlockState state) {
        Boolean lit = (Boolean)state.getValue((Property)LIT);
        return lit != false ? 15 : 0;
    }

    @NotNull
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction face = (Direction)pState.getValue((Property)FACING);
        if (face.getAxis().isVertical()) {
            face = face == Direction.DOWN ? Direction.UP : Direction.DOWN;
        }
        return DnDecorShapes.shape(3.0, 3.0, 8.0, 13.0, 13.0, 16.0).forDirectional(Direction.NORTH).get(face);
    }

    protected boolean hasNeighborSignal(Level level, BlockPos pos, Direction direction) {
        return level.hasSignal(pos.relative(direction), direction) || level.hasNeighborSignal(pos.relative(direction));
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        boolean flag = this.hasNeighborSignal(level, pos, ((Direction)state.getValue((Property)FACING)).getOpposite());
        if (flag != (Boolean)state.getValue((Property)LIT)) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(flag)));
            level.playSound(null, pos, (Boolean)state.getValue((Property)LIT) != false ? SoundEvents.COPPER_BULB_TURN_ON : SoundEvents.COPPER_BULB_TURN_OFF, SoundSource.BLOCKS);
        }
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction face = context.getClickedFace();
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        BlockState base = (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)face);
        if (!base.canSurvive((LevelReader)level, pos)) {
            return null;
        }
        boolean flag = this.hasNeighborSignal(level, pos, face.getOpposite());
        if (flag != (Boolean)base.getValue((Property)LIT)) {
            base = (BlockState)base.setValue((Property)LIT, (Comparable)Boolean.valueOf(flag));
        }
        if (face.getAxis().isVertical()) {
            base = (BlockState)base.setValue(ADDITIVE, (Comparable)((Object)Frontlight.EMPTY));
        }
        return base;
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        return Block.canSupportCenter((LevelReader)level, (BlockPos)pos.relative(dir.getOpposite()), (Direction)dir);
    }

    @NotNull
    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        return !state.canSurvive((LevelReader)level, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    @NotNull
    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    protected BlockState mirror(BlockState state, Mirror mirror) {
        return this.rotate(state, mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        BlockState rotated;
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction face = context.getClickedFace();
        BlockState blockState = rotated = face.getAxis().equals((Object)((Direction)state.getValue((Property)FACING)).getAxis()) ? (BlockState)state.cycle((Property)ROTATED) : (BlockState)state.cycle(ADDITIVE);
        if (!rotated.canSurvive((LevelReader)level, context.getClickedPos())) {
            return InteractionResult.PASS;
        }
        KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)pos, (BlockState)this.updateAfterWrenched(rotated, context));
        if (level.getBlockState(pos) != state) {
            AllSoundEvents.WRENCH_ROTATE.playOnServer(level, (Vec3i)pos, 1.0f, level.random.nextFloat() + 0.5f);
        }
        return InteractionResult.SUCCESS;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, LIT, ADDITIVE, ROTATED});
    }
}

