/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndecor.content.blocks.storage_container;

import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.item.ItemHelper;
import dev.lopyluna.dndecor.content.blocks.storage_container.ColoredStorageContainerBlockEntity;
import dev.lopyluna.dndecor.register.DnDecorBETypes;
import dev.lopyluna.dndecor.register.DnDecorBlocks;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.util.DeferredSoundType;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class ColoredStorageContainerBlock
extends Block
implements IWrenchable,
IBE<ColoredStorageContainerBlockEntity> {
    public static final Property<Direction.Axis> HORIZONTAL_AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    public static final BooleanProperty LARGE = BooleanProperty.create((String)"large");
    public static final EnumProperty<DyeColor> COLOR = EnumProperty.create((String)"colors", DyeColor.class);
    public static final SoundType SILENCED_METAL = new DeferredSoundType(0.1f, 1.5f, () -> SoundEvents.NETHERITE_BLOCK_BREAK, () -> SoundEvents.NETHERITE_BLOCK_STEP, () -> SoundEvents.NETHERITE_BLOCK_PLACE, () -> SoundEvents.NETHERITE_BLOCK_HIT, () -> SoundEvents.NETHERITE_BLOCK_FALL);

    public ColoredStorageContainerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)LARGE, (Comparable)Boolean.valueOf(false))).setValue(COLOR, (Comparable)DyeColor.WHITE));
    }

    @ParametersAreNonnullByDefault
    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        DyeItem dyeItem;
        Item item = pStack.getItem();
        if (item instanceof DyeItem && this.applyDye(pState, pLevel, pPos, (dyeItem = (DyeItem)item).getDyeColor(), pPlayer, pStack)) {
            pLevel.playSound(null, pPos, SoundEvents.DYE_USE, SoundSource.BLOCKS, 1.0f, 1.1f - pLevel.random.nextFloat() * 0.2f);
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(pStack, pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    public boolean applyDye(BlockState pState, Level pLevel, BlockPos pPos, @Nullable DyeColor pDyeColor, Player pPlayer, ItemStack pDyeStack) {
        BlockEntity blockEntity;
        assert (pDyeColor != null);
        if (!pState.hasProperty(COLOR) || pDyeStack.isEmpty() || !((blockEntity = pLevel.getBlockEntity(pPos)) instanceof ColoredStorageContainerBlockEntity)) {
            return false;
        }
        ColoredStorageContainerBlockEntity be = (ColoredStorageContainerBlockEntity)blockEntity;
        ColoredStorageContainerBlockEntity controllerBE = be.getControllerBE();
        if (controllerBE == null) {
            return false;
        }
        BlockState blockState = pLevel.getBlockState(controllerBE.getBlockPos());
        BlockState newState = (BlockState)blockState.setValue(COLOR, (Comparable)pDyeColor);
        if (blockState.getValue(COLOR) != newState.getValue(COLOR)) {
            ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
            if (be.isController()) {
                int radius = be.radius;
                int length = be.length;
                for (int y = 0; y < radius; ++y) {
                    for (int z = 0; z < (controllerBE.axis == Direction.Axis.X ? radius : length); ++z) {
                        for (int x = 0; x < (controllerBE.axis == Direction.Axis.Z ? radius : length); ++x) {
                            BlockPos pos = controllerBE.getBlockPos().offset(x, y, z);
                            BlockState stateAtPos = pLevel.getBlockState(pos);
                            BlockEntity blockEntity2 = pLevel.getBlockEntity(pos);
                            if (blockEntity2 instanceof ColoredStorageContainerBlockEntity) {
                                ColoredStorageContainerBlockEntity be2 = (ColoredStorageContainerBlockEntity)blockEntity2;
                                if (be.getController() != be2.getController()) continue;
                            }
                            if (stateAtPos.isAir() || !stateAtPos.hasProperty(COLOR)) continue;
                            positions.add(pos);
                        }
                    }
                }
            }
            pLevel.setBlockAndUpdate(controllerBE.getBlockPos(), (BlockState)controllerBE.getBlockState().setValue(COLOR, (Comparable)pDyeColor));
            for (BlockPos pos : positions) {
                pLevel.setBlockAndUpdate(pos, (BlockState)pLevel.getBlockState(pos).setValue(COLOR, (Comparable)pDyeColor));
            }
            if (!pPlayer.isCreative()) {
                pDyeStack.shrink(1);
            }
            return true;
        }
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{HORIZONTAL_AXIS, LARGE, COLOR});
        super.createBlockStateDefinition(pBuilder);
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockState placedOn;
        Direction.Axis preferredAxis;
        if (!(pContext.getPlayer() != null && pContext.getPlayer().isShiftKeyDown() || (preferredAxis = ColoredStorageContainerBlock.getVaultBlockAxis(placedOn = pContext.getLevel().getBlockState(pContext.getClickedPos().relative(pContext.getClickedFace().getOpposite())))) == null)) {
            return (BlockState)this.defaultBlockState().setValue(HORIZONTAL_AXIS, (Comparable)preferredAxis);
        }
        return (BlockState)this.defaultBlockState().setValue(HORIZONTAL_AXIS, (Comparable)pContext.getHorizontalDirection().getAxis());
    }

    public void onPlace(BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (pOldState.getBlock() == pState.getBlock()) {
            return;
        }
        if (pIsMoving) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)pLevel, pPos, ColoredStorageContainerBlockEntity::updateConnectivity);
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        if (context.getClickedFace().getAxis().isVertical()) {
            BlockEntity be = context.getLevel().getBlockEntity(context.getClickedPos());
            if (be instanceof ColoredStorageContainerBlockEntity) {
                ColoredStorageContainerBlockEntity vault = (ColoredStorageContainerBlockEntity)be;
                ConnectivityHandler.splitMulti((BlockEntity)vault);
                vault.removeController(true);
            }
            state = (BlockState)state.setValue((Property)LARGE, (Comparable)Boolean.valueOf(false));
        }
        return super.onWrenched(state, context);
    }

    public void onRemove(BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState newState, boolean pIsMoving) {
        if (state.hasBlockEntity() && (state.getBlock() != newState.getBlock() || !newState.hasBlockEntity())) {
            BlockEntity be = world.getBlockEntity(pos);
            if (!(be instanceof ColoredStorageContainerBlockEntity)) {
                return;
            }
            ColoredStorageContainerBlockEntity vaultBE = (ColoredStorageContainerBlockEntity)be;
            ItemHelper.dropContents((Level)world, (BlockPos)pos, (IItemHandler)vaultBE.inventory);
            world.removeBlockEntity(pos);
            ConnectivityHandler.splitMulti((BlockEntity)vaultBE);
        }
    }

    public static boolean isVault(BlockState state) {
        return DnDecorBlocks.DYED_STORAGE_CONTAINER.has(state);
    }

    @Nullable
    public static Direction.Axis getVaultBlockAxis(BlockState state) {
        if (!ColoredStorageContainerBlock.isVault(state)) {
            return null;
        }
        return (Direction.Axis)state.getValue(HORIZONTAL_AXIS);
    }

    public static boolean isLarge(BlockState state) {
        if (!ColoredStorageContainerBlock.isVault(state)) {
            return false;
        }
        return (Boolean)state.getValue((Property)LARGE);
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rot) {
        Direction.Axis axis = (Direction.Axis)state.getValue(HORIZONTAL_AXIS);
        return (BlockState)state.setValue(HORIZONTAL_AXIS, (Comparable)rot.rotate(Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE)).getAxis());
    }

    @NotNull
    public BlockState mirror(@NotNull BlockState state, @NotNull Mirror mirrorIn) {
        return state;
    }

    @NotNull
    public SoundType getSoundType(@NotNull BlockState state, @NotNull LevelReader world, @NotNull BlockPos pos, Entity entity) {
        SoundType soundType = super.getSoundType(state, world, pos, entity);
        if (entity != null && entity.getPersistentData().contains("SilenceVaultSound")) {
            return SILENCED_METAL;
        }
        return soundType;
    }

    public boolean hasAnalogOutputSignal(@NotNull BlockState p_149740_1_) {
        return true;
    }

    public int getAnalogOutputSignal(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos) {
        return ItemHelper.calcRedstoneFromBlockEntity((IBE)this, (Level)pLevel, (BlockPos)pPos);
    }

    public BlockEntityType<? extends ColoredStorageContainerBlockEntity> getBlockEntityType() {
        return (BlockEntityType)DnDecorBETypes.COLORED_STORAGE_CONTAINER.get();
    }

    public Class<ColoredStorageContainerBlockEntity> getBlockEntityClass() {
        return ColoredStorageContainerBlockEntity.class;
    }
}

