/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndecor.content.entries;

import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.SharedProperties;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.util.DataIngredient;
import com.tterrag.registrate.util.entry.BlockEntry;
import dev.lopyluna.dndecor.DnDecor;
import dev.lopyluna.dndecor.content.blocks.bolt.BoltBlock;
import dev.lopyluna.dndecor.content.blocks.bolt.BoltRotation;
import dev.lopyluna.dndecor.register.AllMetalTypes;
import dev.lopyluna.dndecor.register.DnDecorTags;
import dev.lopyluna.dndecor.register.helpers.MetalTypeHelper;
import dev.lopyluna.dndecor.register.helpers.list_providers.MaterialTypeProvider;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;

public class BoltEntry<T extends Block> {
    public BlockEntry<BoltBlock> CROSS;
    public BlockEntry<BoltBlock> DASH;
    public BlockEntry<BoltBlock> DOT;
    public BlockEntry<BoltBlock> FLAT;

    public boolean is(Block entry) {
        return this.CROSS.get() == entry || this.DASH.get() == entry || this.DOT.get() == entry || this.FLAT.get() == entry;
    }

    public BlockBuilder<BoltBlock, CreateRegistrate> buildBolts(BlockBuilder<BoltBlock, CreateRegistrate> builder, MaterialTypeProvider.MetalType metal, MapColor color, String type, String boltType) {
        BlockBuilder build = builder.initialProperties(SharedProperties::netheriteMetal).properties(p -> p.mapColor(color)).blockstate((c, p) -> p.getVariantBuilder((Block)c.get()).forAllStates(BoltEntry.boltStates(c, p, type, boltType)));
        build = metal.equals(AllMetalTypes.NETHERITE) ? (BlockBuilder)build.item().properties(Item.Properties::fireResistant).transform(b -> (BlockBuilder)b.model((c, p) -> p.blockItem(() -> ((BlockItem)c.getEntry()).getBlock(), "/block_0")).build()) : (BlockBuilder)build.item().transform(b -> (BlockBuilder)b.model((c, p) -> p.blockItem(() -> ((BlockItem)c.getEntry()).getBlock(), "/block_0")).build());
        return build;
    }

    public BoltEntry(MaterialTypeProvider.MetalType metal) {
        String type = metal.id;
        MapColor mapColor = metal.color;
        BlockBuilder builderCross = DnDecor.REGISTRATE.block(type + "_cross_bolt", BoltBlock::new);
        builderCross = this.buildBolts((BlockBuilder<BoltBlock, CreateRegistrate>)builderCross, metal, mapColor, type, "cross");
        BlockBuilder builderDash = DnDecor.REGISTRATE.block(type + "_dash_bolt", BoltBlock::new);
        builderDash = this.buildBolts((BlockBuilder<BoltBlock, CreateRegistrate>)builderDash, metal, mapColor, type, "dash");
        BlockBuilder builderDot = DnDecor.REGISTRATE.block(type + "_dot_bolt", BoltBlock::new);
        builderDot = this.buildBolts((BlockBuilder<BoltBlock, CreateRegistrate>)builderDot, metal, mapColor, type, "dot");
        BlockBuilder builderFlat = DnDecor.REGISTRATE.block(type + "_flat_bolt", BoltBlock::new);
        builderFlat = this.buildBolts((BlockBuilder<BoltBlock, CreateRegistrate>)builderFlat, metal, mapColor, type, "flat");
        builderCross = builderCross.recipe((c, p) -> {
            DataIngredient ingredient = metal.getIngredient();
            if (ingredient != null) {
                p.stonecutting(ingredient, RecipeCategory.BUILDING_BLOCKS, (Supplier)c, 4);
            }
        });
        builderDash = builderDash.recipe((c, p) -> {
            DataIngredient ingredient = metal.getIngredient();
            if (ingredient != null) {
                p.stonecutting(ingredient, RecipeCategory.BUILDING_BLOCKS, (Supplier)c, 4);
            }
        });
        builderDot = builderDot.recipe((c, p) -> {
            DataIngredient ingredient = metal.getIngredient();
            if (ingredient != null) {
                p.stonecutting(ingredient, RecipeCategory.BUILDING_BLOCKS, (Supplier)c, 4);
            }
        });
        builderFlat = builderFlat.recipe((c, p) -> {
            DataIngredient ingredient = metal.getIngredient();
            if (ingredient != null) {
                p.stonecutting(ingredient, RecipeCategory.BUILDING_BLOCKS, (Supplier)c, 4);
            }
        });
        TagKey<Block> boltMineable = DnDecorTags.modBlockTag("mineable/pickaxe/" + type + "_bolt");
        MetalTypeHelper.create("pickaxe", boltMineable);
        builderCross = builderCross.tag(new TagKey[]{boltMineable});
        builderDash = builderDash.tag(new TagKey[]{boltMineable});
        builderDot = builderDot.tag(new TagKey[]{boltMineable});
        builderFlat = builderFlat.tag(new TagKey[]{boltMineable});
        this.CROSS = builderCross.register();
        this.DASH = builderDash.register();
        this.DOT = builderDot.register();
        this.FLAT = builderFlat.register();
    }

    public static <T extends Block> Function<BlockState, ConfiguredModel[]> boltStates(DataGenContext<Block, T> c, RegistrateBlockstateProvider p, String material, String type) {
        return state -> {
            Direction facing = (Direction)state.getValue((Property)BoltBlock.FACING);
            int getX = switch (facing) {
                default -> throw new MatchException(null, null);
                case Direction.DOWN -> 180;
                case Direction.UP -> 0;
                case Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST -> 90;
            };
            int getY = switch (facing) {
                default -> throw new MatchException(null, null);
                case Direction.DOWN, Direction.UP, Direction.NORTH -> 0;
                case Direction.SOUTH -> 180;
                case Direction.WEST -> 270;
                case Direction.EAST -> 90;
            };
            BoltRotation rot = (BoltRotation)((Object)((Object)state.getValue(BoltBlock.ROT)));
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent("block/" + c.getName() + "/block_" + rot.getName(), DnDecor.asResource("block/bolt_base/" + type + "/bolt_" + rot.getName()))).texture("0", DnDecor.asResource("block/" + material + "_bolt"))).texture("particle", DnDecor.asResource("block/" + material + "_bolt"))).rotationY(getY).rotationX(getX).build();
        };
    }
}

