/*
 * Decompiled with CFR 0.152.
 */
package com.serpenssolida.createtransmission.content.chain;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.serpenssolida.createtransmission.CTModels;
import com.serpenssolida.createtransmission.CTSpriteShifts;
import com.serpenssolida.createtransmission.content.chain.AbstractTransmissionChainBlock;
import com.serpenssolida.createtransmission.content.chain.TransmissionChainBlock;
import com.serpenssolida.createtransmission.content.chain.TransmissionChainBlockEntity;
import com.serpenssolida.createtransmission.content.chain.TransmissionChainHelpers;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SpriteShiftEntry;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class TransmissionChainRenderer
extends SafeBlockEntityRenderer<TransmissionChainBlockEntity> {
    public TransmissionChainRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(TransmissionChainBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (VisualizationManager.supportsVisualization((LevelAccessor)be.getLevel())) {
            return;
        }
        float renderTick = AnimationTickHolder.getRenderTime((LevelAccessor)be.getLevel());
        PoseStack localTransforms = new PoseStack();
        PoseTransformStack msr = TransformStack.of((PoseStack)localTransforms);
        VertexConsumer vb = buffer.getBuffer(RenderType.solid());
        TransmissionChainHelpers.ChainConnection connection = AbstractTransmissionChainBlock.getConnection(be.getBlockState());
        Direction facing = (Direction)be.getBlockState().getValue((Property)TransmissionChainBlock.FACING);
        Quaternionf rotation = TransmissionChainHelpers.getRotation(be);
        msr.rotateCentered((Quaternionfc)rotation);
        PartialModel beltPartial = this.getChainModel(connection.type());
        SuperByteBuffer chainBuffer = CachedBuffers.partial((PartialModel)beltPartial, (BlockState)be.getBlockState()).light(light);
        SpriteShiftEntry spriteShift = CTSpriteShifts.CHAIN;
        float speed = this.getChainRotationalSpeed(facing, be) * be.getRotationSpeedModifier(facing);
        if (speed != 0.0f) {
            float scrollMult = 0.5f;
            float spriteSize = spriteShift.getTarget().getV1() - spriteShift.getTarget().getV0();
            double scroll = (double)(speed * renderTick) / 504.0;
            scroll -= Math.floor(scroll);
            scroll = scroll * (double)spriteSize * (double)scrollMult;
            chainBuffer.shiftUVScrolling(spriteShift, (float)scroll);
        }
        ((SuperByteBuffer)chainBuffer.transform(localTransforms)).renderInto(ms, vb);
    }

    private PartialModel getChainModel(TransmissionChainHelpers.ConnectionType connectionType) {
        if (connectionType == TransmissionChainHelpers.ConnectionType.NONE) {
            return CTModels.CHAIN;
        }
        return connectionType == TransmissionChainHelpers.ConnectionType.CHAIN ? CTModels.CHAIN_CONNECTED : CTModels.CHAIN_BELT;
    }

    private float getChainRotationalSpeed(Direction direction, TransmissionChainBlockEntity blockEntity) {
        return (float)direction.getAxisDirection().getStep() * -blockEntity.getSpeed() * 0.415f;
    }
}

