/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.cake;

import com.mrh0.createaddition.datagen.Models.BlockGenHelper;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.client.model.generators.BlockModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;

public class CACakeBlock
extends CakeBlock {
    public CACakeBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.CONSUME;
        }
        return CACakeBlock.eat((LevelAccessor)level, pos, state, player);
    }

    protected static InteractionResult eat(LevelAccessor world, BlockPos pos, BlockState state, Player player) {
        if (!player.canEat(false)) {
            return InteractionResult.PASS;
        }
        player.awardStat(Stats.EAT_CAKE_SLICE);
        player.getFoodData().eat(3, 0.3f);
        int i = (Integer)state.getValue((Property)BITES);
        if (i < 6) {
            world.setBlock(pos, (BlockState)state.setValue((Property)BITES, (Comparable)Integer.valueOf(i + 1)), 3);
        } else {
            world.removeBlock(pos, false);
        }
        return InteractionResult.SUCCESS;
    }

    public static <T extends Block> void makeBlockState(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider provider) {
        BlockModelProvider models = provider.models();
        String basePath = "block/" + BlockGenHelper.getBlockName((Block)ctx.get()) + "/";
        MultiPartBlockStateBuilder builder = provider.getMultipartBuilder((Block)ctx.get());
        for (Integer bytes : BITES.getPossibleValues()) {
            if (bytes == 0) {
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)models.getExistingFile(ResourceLocation.fromNamespaceAndPath((String)"createaddition", (String)(basePath + "cake")))).addModel()).condition((Property)BITES, (Comparable[])new Integer[]{0}).end();
                continue;
            }
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)models.getExistingFile(ResourceLocation.fromNamespaceAndPath((String)"createaddition", (String)(basePath + "slice" + bytes)))).addModel()).condition((Property)BITES, (Comparable[])new Integer[]{bytes}).end();
        }
    }
}

