/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.connector;

import com.mrh0.createaddition.blocks.connector.LargeConnectorBlockEntity;
import com.mrh0.createaddition.blocks.connector.base.AbstractConnectorBlock;
import com.mrh0.createaddition.blocks.connector.base.ConnectorMode;
import com.mrh0.createaddition.blocks.connector.base.ConnectorVariant;
import com.mrh0.createaddition.index.CABlockEntities;
import com.mrh0.createaddition.shapes.CAShapes;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.model.generators.BlockModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;

public class LargeConnectorBlock
extends AbstractConnectorBlock<LargeConnectorBlockEntity> {
    public static final VoxelShaper CONNECTOR_SHAPE = CAShapes.shape(5.0, 0.0, 5.0, 11.0, 7.0, 11.0).forDirectional();

    public LargeConnectorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public Class<LargeConnectorBlockEntity> getBlockEntityClass() {
        return LargeConnectorBlockEntity.class;
    }

    public BlockEntityType<? extends LargeConnectorBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CABlockEntities.LARGE_CONNECTOR.get();
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return CABlockEntities.LARGE_CONNECTOR.create(pos, state);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return CONNECTOR_SHAPE.get(((Direction)state.getValue((Property)FACING)).getOpposite());
    }

    public static void makeBlockState(DataGenContext<Block, LargeConnectorBlock> ctx, RegistrateBlockstateProvider provider) {
        BlockModelProvider models = provider.models();
        String basePath = "block/connector/";
        String basePathLarge = basePath + "large/";
        MultiPartBlockStateBuilder builder = provider.getMultipartBuilder((Block)ctx.get());
        ModelFile.ExistingModelFile noneModel = models.getExistingFile(ResourceLocation.fromNamespaceAndPath((String)"createaddition", (String)(basePathLarge + "none")));
        ModelFile.ExistingModelFile pushModel = models.getExistingFile(ResourceLocation.fromNamespaceAndPath((String)"createaddition", (String)(basePathLarge + "push")));
        ModelFile.ExistingModelFile pullModel = models.getExistingFile(ResourceLocation.fromNamespaceAndPath((String)"createaddition", (String)(basePathLarge + "pull")));
        ModelFile.ExistingModelFile girderBaseModel = models.getExistingFile(ResourceLocation.fromNamespaceAndPath((String)"createaddition", (String)(basePath + "girder_base")));
        for (Direction direction : Direction.values()) {
            int horizontalAngle = direction == Direction.UP ? 180 : (direction == Direction.DOWN ? 0 : 90);
            int verticalAngle = ((int)direction.toYRot() + (direction.getAxis().isVertical() ? 180 : 0)) % 360;
            ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)noneModel).rotationX(horizontalAngle).rotationY(verticalAngle).addModel()).condition((Property)FACING, (Comparable[])new Direction[]{direction}).condition((Property)MODE, (Comparable[])new ConnectorMode[]{ConnectorMode.None}).end().part().modelFile((ModelFile)pushModel).rotationX(horizontalAngle).rotationY(verticalAngle).addModel()).condition((Property)FACING, (Comparable[])new Direction[]{direction}).condition((Property)MODE, (Comparable[])new ConnectorMode[]{ConnectorMode.Push}).end().part().modelFile((ModelFile)pullModel).rotationX(horizontalAngle).rotationY(verticalAngle).addModel()).condition((Property)FACING, (Comparable[])new Direction[]{direction}).condition((Property)MODE, (Comparable[])new ConnectorMode[]{ConnectorMode.Pull}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)girderBaseModel).rotationX(horizontalAngle).rotationY(verticalAngle).addModel()).condition((Property)FACING, (Comparable[])new Direction[]{direction}).condition((Property)VARIANT, (Comparable[])new ConnectorVariant[]{ConnectorVariant.Girder}).end();
        }
    }
}

