/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_power_loader;

import net.createmod.catnip.lang.Lang;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public class CPLTags {
    public static <T> TagKey<T> optionalTag(DefaultedRegistry<T> registry, ResourceLocation id) {
        TagKey tagKey = TagKey.create((ResourceKey)registry.key(), (ResourceLocation)id);
        registry.getOrCreateTag(tagKey);
        return tagKey;
    }

    public static <T> TagKey<T> forgeTag(DefaultedRegistry<T> registry, String path) {
        return CPLTags.optionalTag(registry, ResourceLocation.fromNamespaceAndPath((String)"c", (String)path));
    }

    public static TagKey<Block> forgeBlockTag(String path) {
        return CPLTags.forgeTag(BuiltInRegistries.BLOCK, path);
    }

    public static TagKey<Item> forgeItemTag(String path) {
        return CPLTags.forgeTag(BuiltInRegistries.ITEM, path);
    }

    public static TagKey<Fluid> forgeFluidTag(String path) {
        return CPLTags.forgeTag(BuiltInRegistries.FLUID, path);
    }

    public static void register() {
        AllEntityTags.register();
    }

    public static enum AllEntityTags {
        CHUNK_LOADER_CAPTURABLE;

        public final TagKey<EntityType<?>> tag;
        public final boolean alwaysDatagen;

        private AllEntityTags() {
            this(NameSpace.MOD);
        }

        private AllEntityTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllEntityTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllEntityTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private AllEntityTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace.id, (String)(path == null ? Lang.asId((String)this.name()) : path));
            this.tag = optional ? CPLTags.optionalTag(BuiltInRegistries.ENTITY_TYPE, id) : TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(EntityType<?> type) {
            return type.is(this.tag);
        }

        public boolean matches(Entity entity) {
            return this.matches(entity.getType());
        }

        private static void register() {
        }
    }

    public static enum NameSpace {
        MOD("create_power_loader", false, true),
        FORGE("forge");

        public final String id;
        public final boolean optionalDefault;
        public final boolean alwaysDatagenDefault;

        private NameSpace(String id) {
            this(id, true, false);
        }

        private NameSpace(String id, boolean optionalDefault, boolean alwaysDatagenDefault) {
            this.id = id;
            this.optionalDefault = optionalDefault;
            this.alwaysDatagenDefault = alwaysDatagenDefault;
        }
    }
}

