/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_power_loader.content.trains;

import com.hlysine.create_power_loader.CPLBlocks;
import com.hlysine.create_power_loader.config.CPLConfigs;
import com.hlysine.create_power_loader.content.ChunkLoadManager;
import com.hlysine.create_power_loader.content.ChunkLoader;
import com.hlysine.create_power_loader.content.LoaderMode;
import com.hlysine.create_power_loader.content.LoaderType;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.entity.TravellingPoint;
import java.util.HashSet;
import java.util.Set;
import net.createmod.catnip.data.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.NotNull;

public class CarriageChunkLoader
implements ChunkLoader {
    public final Carriage carriage;
    public boolean known;
    public boolean andesite;
    public boolean brass;
    public final Set<ChunkLoadManager.LoadedChunkPos> forcedChunks = new HashSet<ChunkLoadManager.LoadedChunkPos>();

    public CarriageChunkLoader(Carriage carriage, boolean known, boolean andesite, boolean brass) {
        this.carriage = carriage;
        this.known = known;
        this.andesite = andesite;
        this.brass = brass;
    }

    @Override
    @NotNull
    public Set<ChunkLoadManager.LoadedChunkPos> getForcedChunks() {
        return this.forcedChunks;
    }

    @Override
    public LoaderMode getLoaderMode() {
        return LoaderMode.TRAIN;
    }

    @Override
    public LoaderType getLoaderType() {
        return this.brass ? LoaderType.BRASS : LoaderType.ANDESITE;
    }

    @Override
    public Pair<ResourceLocation, BlockPos> getLocation() {
        if (this.carriage.train.graph == null) {
            return null;
        }
        return Pair.of((Object)this.carriage.leadingBogey().trailing().node1.getLocation().getDimension().location(), (Object)BlockPos.containing((Position)this.carriage.leadingBogey().trailing().getPosition(this.carriage.train.graph)));
    }

    public void tick(Level level) {
        if (!this.known) {
            this.updateCarriage();
        }
        if (!this.known) {
            return;
        }
        if (!this.canLoadChunks()) {
            if (!this.forcedChunks.isEmpty()) {
                ChunkLoadManager.unforceAllChunks(level.getServer(), this.carriage.train.id, this.forcedChunks);
            }
            return;
        }
        HashSet<ChunkLoadManager.LoadedChunkPos> loadTargets = new HashSet<ChunkLoadManager.LoadedChunkPos>();
        this.addLoadTargets(loadTargets, this.carriage.leadingBogey().trailing());
        this.addLoadTargets(loadTargets, this.carriage.trailingBogey().leading());
        ChunkLoadManager.updateForcedChunks(level.getServer(), loadTargets, this.carriage.train.id, (int)((Integer)CPLConfigs.server().getFor((LoaderType)this.getLoaderType()).rangeOnTrain.get()), this.forcedChunks);
    }

    public void onRemove() {
        ChunkLoadManager.enqueueUnforceAll(this.carriage.train.id, this.forcedChunks);
    }

    private void addLoadTargets(Set<ChunkLoadManager.LoadedChunkPos> loadTargets, TravellingPoint point) {
        if (point.edge.isInterDimensional()) {
            loadTargets.add(new ChunkLoadManager.LoadedChunkPos(point.node1.getLocation().getDimension().location(), new ChunkPos(BlockPos.containing((Position)point.node1.getLocation().getLocation()))));
            loadTargets.add(new ChunkLoadManager.LoadedChunkPos(point.node2.getLocation().getDimension().location(), new ChunkPos(BlockPos.containing((Position)point.node2.getLocation().getLocation()))));
        } else {
            loadTargets.add(new ChunkLoadManager.LoadedChunkPos(point.node1.getLocation().getDimension().location(), new ChunkPos(BlockPos.containing((Position)point.getPosition(this.carriage.train.graph)))));
        }
    }

    private void updateCarriage() {
        CarriageContraptionEntity entity = this.carriage.anyAvailableEntity();
        boolean bl = this.known = entity != null;
        if (!this.known) {
            return;
        }
        Contraption contraption = entity.getContraption();
        this.andesite = !contraption.isActorTypeDisabled(ItemStack.EMPTY) && !contraption.isActorTypeDisabled(CPLBlocks.ANDESITE_CHUNK_LOADER.asStack());
        boolean bl2 = this.brass = !contraption.isActorTypeDisabled(ItemStack.EMPTY) && !contraption.isActorTypeDisabled(CPLBlocks.BRASS_CHUNK_LOADER.asStack());
        if (!this.andesite && !this.brass) {
            return;
        }
        boolean hasAndesite = false;
        boolean hasBrass = false;
        for (MutablePair actor : entity.getContraption().getActors()) {
            if (!hasAndesite && ((StructureTemplate.StructureBlockInfo)actor.left).state().is((Block)CPLBlocks.ANDESITE_CHUNK_LOADER.get())) {
                hasAndesite = true;
            }
            if (!hasBrass && ((StructureTemplate.StructureBlockInfo)actor.left).state().is((Block)CPLBlocks.BRASS_CHUNK_LOADER.get())) {
                hasBrass = true;
            }
            if (!hasAndesite || !hasBrass) continue;
            break;
        }
        this.andesite = hasAndesite;
        this.brass = hasBrass;
    }

    private boolean canLoadChunks() {
        if (this.carriage.train.graph == null) {
            return false;
        }
        return this.andesite && (Boolean)CPLConfigs.server().andesite.enableTrain.get() != false || this.brass && (Boolean)CPLConfigs.server().brass.enableTrain.get() != false;
    }

    public CompoundTag write() {
        CompoundTag nbt = new CompoundTag();
        if (this.known) {
            nbt.putBoolean("andesite", this.andesite);
            nbt.putBoolean("brass", this.brass);
        }
        return nbt;
    }

    public static CarriageChunkLoader read(Carriage carriage, CompoundTag nbt) {
        if (nbt.contains("andesite") && nbt.contains("brass")) {
            return new CarriageChunkLoader(carriage, true, nbt.getBoolean("andesite"), nbt.getBoolean("brass"));
        }
        return new CarriageChunkLoader(carriage, false, false, false);
    }
}

