/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.elytraslot.common;

import com.illusivesoulworks.elytraslot.ElytraSlotCommonMod;
import com.illusivesoulworks.elytraslot.common.integration.deeperdarker.DeeperDarkerPlugin;
import com.illusivesoulworks.elytraslot.platform.Services;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class CurioElytra
implements ICurio {
    public static final AttributeModifier ELYTRA_CURIO_MODIFIER = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"elytraslot", (String)"elytra"), 1.0, AttributeModifier.Operation.ADD_VALUE);
    private final ItemStack stack;

    public CurioElytra(ItemStack stack) {
        this.stack = stack;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void curioTick(SlotContext slotContext) {
        LivingEntity livingEntity = slotContext.entity();
        int ticks = livingEntity.getFallFlyingTicks();
        if (ticks > 0 && livingEntity.isFallFlying()) {
            this.stack.elytraFlightTick(livingEntity, ticks);
        }
        if (Services.PLATFORM.isModLoaded("deeperdarker")) {
            DeeperDarkerPlugin.tick(livingEntity.level(), (Entity)livingEntity);
        }
    }

    public boolean canEquip(SlotContext slotContext) {
        return ElytraSlotCommonMod.canEquip(slotContext.entity());
    }

    @Nonnull
    public ICurio.SoundInfo getEquipSound(SlotContext slotContext) {
        return new ICurio.SoundInfo((SoundEvent)SoundEvents.ARMOR_EQUIP_ELYTRA.value(), 1.0f, 1.0f);
    }

    public boolean canEquipFromUse(SlotContext slotContext) {
        return true;
    }
}

