/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.elytraslot.common.integration.deeperdarker;

import com.illusivesoulworks.elytraslot.common.integration.deeperdarker.SoulElytraBoostPayload;
import com.kyanite.deeperdarker.DeeperDarkerConfig;
import com.kyanite.deeperdarker.content.DDItems;
import com.kyanite.deeperdarker.network.SoulElytraClientPacket;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import top.theillusivec4.curios.api.event.CurioChangeEvent;

public class DeeperDarkerPlugin {
    public static void setup(IEventBus eventBus) {
        eventBus.addListener(DeeperDarkerPlugin::registerPayloads);
        NeoForge.EVENT_BUS.addListener(DeeperDarkerPlugin::onCurioChange);
    }

    private static void registerPayloads(RegisterPayloadHandlersEvent evt) {
        evt.registrar("elytraslot").playToServer(SoulElytraBoostPayload.TYPE, SoulElytraBoostPayload.STREAM_CODEC, SoulElytraBoostPayload::handle);
    }

    private static void onCurioChange(CurioChangeEvent evt) {
        if (!evt.getTo().is((Item)DDItems.SOUL_ELYTRA.get()) || evt.getFrom().is((Item)DDItems.SOUL_ELYTRA.get())) {
            return;
        }
        LivingEntity livingEntity = evt.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SoulElytraClientPacket(true), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void tick(Level level, Entity entity) {
        Player player;
        if (level.isClientSide() && entity instanceof Player && (player = (Player)entity).getCooldowns().isOnCooldown((Item)DDItems.SOUL_ELYTRA.get())) {
            float percent = player.getCooldowns().getCooldownPercent((Item)DDItems.SOUL_ELYTRA.get(), 0.0f);
            player.displayClientMessage((Component)Component.translatable((String)"item.deeperdarker.soul_elytra.cooldown", (Object[])new Object[]{(int)Math.ceil(percent * (float)DeeperDarkerConfig.soulElytraCooldown / 20.0f)}), true);
        }
    }
}

