/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.kineticbridge;

import com.hlysine.create_connected.ConnectedLang;
import com.hlysine.create_connected.content.kineticbridge.KineticBridgeBlock;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class KineticBridgeBlockItem
extends BlockItem {
    public KineticBridgeBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public InteractionResult place(BlockPlaceContext ctx) {
        InteractionResult result = super.place(ctx);
        if (result == InteractionResult.FAIL && ctx.getLevel().isClientSide()) {
            CatnipServices.PLATFORM.executeOnClientOnly(() -> () -> this.showBounds(ctx));
        }
        return result;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void showBounds(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        Direction facing = ((KineticBridgeBlock)this.getBlock()).getDirectionForPlacement(context);
        Player player = context.getPlayer();
        if (!(player instanceof LocalPlayer)) {
            return;
        }
        LocalPlayer localPlayer = (LocalPlayer)player;
        Outliner.getInstance().showAABB((Object)Pair.of((Object)"kinetic_bridge", (Object)pos), new AABB(pos).expandTowards((double)facing.getNormal().getX(), (double)facing.getNormal().getY(), (double)facing.getNormal().getZ())).colored(-41620);
        ConnectedLang.translate("kinetic_bridge.not_enough_space", new Object[0]).color(-41620).sendStatus((Player)localPlayer);
    }
}

