/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.base.spark;

import com.drmangotea.tfmg.TFMG;
import com.drmangotea.tfmg.base.spark.LithiumSpark;
import com.drmangotea.tfmg.registry.TFMGMobEffects;
import com.simibubi.create.content.trains.CubeParticleData;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class Spark
extends ThrowableProjectile {
    public float gravity = 0.02f;

    public Spark(EntityType<? extends Spark> p_37391_, Level p_37392_) {
        super(p_37391_, p_37392_);
    }

    protected double getDefaultGravity() {
        return this.gravity;
    }

    public Optional<BlockState> getFireState(BlockPos pos) {
        return Optional.of(BaseFireBlock.getState((BlockGetter)this.level(), (BlockPos)pos));
    }

    public float[] getCustomParticleTrail() {
        return new float[]{0.0f, 0.0f, 0.0f};
    }

    public ParticleOptions getTrailParticle() {
        return ParticleTypes.FLAME;
    }

    public ResourceLocation getTexture() {
        return TFMG.asResource("textures/entity/spark.png");
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void burst(double pX, double pY, double pZ, float pVelocity, float pInaccuracy) {
        Vec3 vec3 = new Vec3(pX, pY, pZ).normalize().add(this.random.triangle(0.0, 0.0172275 * (double)pInaccuracy), 0.0, this.random.triangle(0.0, 0.0172275 * (double)pInaccuracy)).scale((double)pVelocity);
        this.setDeltaMovement(vec3);
        double d0 = vec3.horizontalDistance();
        this.setYRot((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2((double)vec3.y, (double)d0) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    public void setGravity(float gravity) {
        this.gravity = gravity;
    }

    public void tick() {
        super.tick();
        if (this.isInWaterOrRain()) {
            this.discard();
        }
        if (this.level().isClientSide) {
            if (this.getCustomParticleTrail()[0] == 0.0f && this.getCustomParticleTrail()[1] == 0.0f && this.getCustomParticleTrail()[2] == 0.0f) {
                this.level().addParticle(this.getTrailParticle(), this.getX(), this.getY(), this.getZ(), this.random.nextGaussian() * 0.05, -this.getDeltaMovement().y * 0.5, this.random.nextGaussian() * 0.05);
            } else {
                CubeParticleData data = new CubeParticleData(this.getCustomParticleTrail()[0], this.getCustomParticleTrail()[1], this.getCustomParticleTrail()[2], 0.0125f + 0.0625f * this.random.nextFloat(), 30, true);
                this.level().addParticle((ParticleOptions)data, this.getX(), this.getY(), this.getZ(), this.random.nextGaussian() * 0.05, -this.getDeltaMovement().y * 0.5, this.random.nextGaussian() * 0.05);
            }
        }
    }

    private ParticleOptions getParticle() {
        return this.getTrailParticle();
    }

    public void handleEntityEvent(byte p_37402_) {
        if (p_37402_ == 3) {
            ParticleOptions particleoptions = this.getParticle();
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle(particleoptions, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void onHitBlock(BlockHitResult hitResult) {
        Entity entity;
        super.onHitBlock(hitResult);
        if (!this.level().isClientSide && !((entity = this.getOwner()) instanceof Mob)) {
            BlockPos blockpos = hitResult.getBlockPos().relative(hitResult.getDirection());
            if (this.level().isEmptyBlock(blockpos) && this.getFireState(blockpos).isPresent()) {
                this.level().setBlockAndUpdate(blockpos, this.getFireState(blockpos).get());
            }
        }
    }

    public int getColor() {
        return 0xFFFF8C;
    }

    protected void onHitEntity(EntityHitResult p_37386_) {
        super.onHitEntity(p_37386_);
        if (!this.level().isClientSide) {
            Entity entity = p_37386_.getEntity();
            entity.igniteForSeconds(4.0f);
            if (entity.getRemainingFireTicks() > 0 && !entity.fireImmune()) {
                entity.hurt(this.damageSources().onFire(), 1.0f);
            }
            if (this instanceof LithiumSpark && entity instanceof LivingEntity) {
                ((LivingEntity)entity).addEffect(new MobEffectInstance(TFMGMobEffects.HELLFIRE, 60));
            }
        }
    }

    protected void onHit(HitResult p_37406_) {
        super.onHit(p_37406_);
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }

    public static EntityType.Builder<?> build(EntityType.Builder<?> builder) {
        EntityType.Builder<?> entityBuilder = builder;
        return entityBuilder.sized(0.25f, 0.25f);
    }
}

