/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.decoration.concrete;

import com.drmangotea.tfmg.registry.TFMGFluids;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;

public interface ConcreteloggedBlock {
    public static final BooleanProperty CONCRETELOGGED = BooleanProperty.create((String)"concretelogged");

    default public FluidState fluidState(BlockState state) {
        return (Boolean)state.getValue((Property)CONCRETELOGGED) != false ? ((BaseFlowingFluid.Flowing)TFMGFluids.LIQUID_CONCRETE.get()).getSource(false) : Fluids.EMPTY.defaultFluidState();
    }

    default public void updateConcrete(LevelAccessor level, BlockState state, BlockPos pos) {
        if (((Boolean)state.getValue((Property)CONCRETELOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)TFMGFluids.LIQUID_CONCRETE.get(), ((BaseFlowingFluid.Flowing)TFMGFluids.LIQUID_CONCRETE.get()).getTickDelay((LevelReader)level));
        }
    }

    default public ItemInteractionResult onClicked(Level level, BlockPos pos, BlockState state, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (((Boolean)state.getValue((Property)CONCRETELOGGED)).booleanValue()) {
            if (stack.is(Items.BUCKET)) {
                level.setBlock(pos, (BlockState)state.setValue((Property)CONCRETELOGGED, (Comparable)Boolean.valueOf(false)), 3);
                if (!player.isCreative()) {
                    player.setItemInHand(hand, ((Item)TFMGFluids.LIQUID_CONCRETE.getBucket().get()).getDefaultInstance());
                }
                player.playSound(SoundEvents.BUCKET_FILL, 1.0f, 1.0f + player.getRandom().nextFloat() * 0.4f);
                return ItemInteractionResult.SUCCESS;
            }
        } else if (stack.is((Item)TFMGFluids.LIQUID_CONCRETE.getBucket().get())) {
            level.setBlock(pos, (BlockState)state.setValue((Property)CONCRETELOGGED, (Comparable)Boolean.valueOf(true)), 3);
            if (!player.isCreative()) {
                player.setItemInHand(hand, Items.BUCKET.getDefaultInstance());
            }
            player.playSound(SoundEvents.BUCKET_EMPTY, 1.0f, 1.0f + player.getRandom().nextFloat() * 0.4f);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    default public void tickDrying(Level level, BlockState state, BlockState newStack, BlockPos pos, RandomSource random) {
        if (!((Boolean)state.getValue((Property)CONCRETELOGGED)).booleanValue()) {
            return;
        }
        int randomInt = random.nextInt(7);
        if (randomInt == 2) {
            level.setBlock(pos, newStack, 3);
        }
    }

    default public BlockState withConcrete(BlockState placementState, BlockPlaceContext ctx) {
        return ConcreteloggedBlock.withConcrete((LevelAccessor)ctx.getLevel(), placementState, ctx.getClickedPos());
    }

    public static BlockState withConcrete(LevelAccessor level, BlockState placementState, BlockPos pos) {
        if (placementState == null) {
            return null;
        }
        FluidState ifluidstate = level.getFluidState(pos);
        if (placementState.isAir()) {
            return ifluidstate.getType() == TFMGFluids.LIQUID_CONCRETE.getSource() ? ifluidstate.createLegacyBlock() : placementState;
        }
        return (BlockState)placementState.setValue((Property)CONCRETELOGGED, (Comparable)Boolean.valueOf(ifluidstate.getType() == TFMGFluids.LIQUID_CONCRETE.getSource()));
    }
}

