/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.display_link;

import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.content.electricity.base.IElectric;
import com.drmangotea.tfmg.content.electricity.utilities.voltage_observer.ObservedElectricBehaviour;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.source.SingleLineDisplaySource;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTargetStats;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.entity.BlockEntity;

public class VoltageDisplaySource
extends SingleLineDisplaySource {
    protected MutableComponent provideLine(DisplayLinkContext context, DisplayTargetStats stats) {
        IElectric observed;
        BlockEntity sourceBE = context.getSourceBlockEntity();
        if (!(sourceBE instanceof SmartBlockEntity)) {
            return EMPTY_LINE;
        }
        SmartBlockEntity smart = (SmartBlockEntity)sourceBE;
        if (!(smart instanceof IElectric)) {
            return EMPTY_LINE;
        }
        IElectric electric = (IElectric)smart;
        int voltage = electric.getData().getVoltage();
        if (smart.getBehaviour(ObservedElectricBehaviour.TYPE) != null && (observed = ((ObservedElectricBehaviour)smart.getBehaviour(ObservedElectricBehaviour.TYPE)).getObservedElectric()) != null) {
            voltage = observed.getData().getVoltage();
        }
        return Component.literal((String)TFMGUtils.formatUnits(voltage, "V"));
    }

    protected String getTranslationKey() {
        return "electricity.voltage";
    }

    protected boolean allowsLabeling(DisplayLinkContext context) {
        return true;
    }
}

