/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.generators.large_generator;

import com.drmangotea.tfmg.content.electricity.base.ElectricBlockEntity;
import com.drmangotea.tfmg.content.electricity.generators.large_generator.RotorBlockEntity;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class StatorBlockEntity
extends ElectricBlockEntity
implements IHaveGoggleInformation {
    public BlockPos rotor = null;
    public int timer = 0;

    public StatorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void setRotor(RotorBlockEntity be) {
        this.rotor = be.getBlockPos();
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.rotor != null && !(this.level.getBlockEntity(this.rotor) instanceof RotorBlockEntity)) {
            this.rotor = null;
        }
    }

    @Override
    public int getMaxVoltage() {
        return 10000;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.timer > 0) {
            if (this.timer == 1) {
                this.updateNextTick();
            }
            --this.timer;
        }
    }

    public void updateRotor() {
        Iterable blocksAround = BlockPos.betweenClosed((BlockPos)this.getBlockPos().below().north().west(), (BlockPos)this.getBlockPos().above().east().east());
        for (BlockPos blockPos : blocksAround) {
            BlockEntity blockEntity = this.level.getBlockEntity(blockPos);
            if (!(blockEntity instanceof RotorBlockEntity)) continue;
            RotorBlockEntity be = (RotorBlockEntity)blockEntity;
            be.updateNextTick();
            this.timer = 11;
        }
    }

    @Override
    public void onPlaced() {
        BlockEntity blockEntity;
        super.onPlaced();
        this.updateRotor();
        if (this.rotor != null && (blockEntity = this.level.getBlockEntity(this.rotor)) instanceof RotorBlockEntity) {
            RotorBlockEntity be = (RotorBlockEntity)blockEntity;
            this.timer = 11;
            be.findNextTick = true;
        }
    }

    public void destroy() {
        BlockEntity blockEntity;
        super.destroy();
        this.updateRotor();
        if (this.rotor != null && (blockEntity = this.level.getBlockEntity(this.rotor)) instanceof RotorBlockEntity) {
            RotorBlockEntity be = (RotorBlockEntity)blockEntity;
            be.updateNextTick();
            be.findNextTick = true;
        }
    }
}

